/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.mappers;

import java.nio.file.Path;
import java.nio.file.Paths;
import sbt.internal.inc.Stamper$;
import sbt.internal.inc.mappers.MapperUtils;
import scala.Predef$;
import scala.collection.StringOps$;
import xsbti.compile.analysis.Stamp;

public final class MapperUtils$ {
    public static final MapperUtils$ MODULE$ = new MapperUtils$();
    private static final int MARKER_LENGTH = "\u2603\u2603\u2603".length();

    public Path rebase(Path target, Path from, Path to) {
        return to.resolve(from.relativize(target));
    }

    private final String RELATIVE_MARKER() {
        return "\u2603\u2603\u2603";
    }

    private final int MARKER_LENGTH() {
        return MARKER_LENGTH;
    }

    private final String relativeReadError(String path, Path from) {
        return new StringBuilder(99).append("Unexpected path ").append(path).append(" was not written by a relative write mapper for root ").append(from).append(". Paths have to start with ").append("\u2603\u2603\u2603").toString();
    }

    public Path makeRelative(Path file, Path from) {
        Path relativePath = from.relativize(file);
        return Paths.get(new StringBuilder(3).append("\u2603\u2603\u2603").append(relativePath).toString(), new String[0]);
    }

    public Path reconstructRelative(Path file, Path from) {
        String filePath = ((Object)file).toString();
        if (!filePath.startsWith("\u2603\u2603\u2603")) {
            throw new MapperUtils.RelativePathAssumptionBroken(this.relativeReadError(filePath, from));
        }
        String cleanPath = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(filePath), this.MARKER_LENGTH());
        return from.resolve(cleanPath);
    }

    public Stamp recomputeModificationDate(Path previouslyStampedFile) {
        return (Stamp)Stamper$.MODULE$.forLastModifiedP().apply((Object)previouslyStampedFile);
    }

    private MapperUtils$() {
    }
}

