/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.IRemoveLeadingLineBreakAndSpaces;
import org.rythmengine.internal.parser.IRemoveLeadingSpacesIfLineBreak;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.ParserDispatcher;
import org.rythmengine.internal.parser.build_in.BlockCloseParser;
import org.rythmengine.internal.parser.build_in.CodeTypeBlockEndSensor;
import org.rythmengine.internal.parser.build_in.CodeTypeBlockStartSensor;
import org.rythmengine.internal.parser.build_in.DirectiveCommentEndSensor;
import org.rythmengine.internal.parser.build_in.DirectiveCommentStartSensor;
import org.rythmengine.internal.parser.build_in.ScriptParser;
import org.rythmengine.internal.parser.build_in.StringTokenParser;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.F;

public class TemplateTokenizer
implements Iterable<Token> {
    private static final ILogger logger = Logger.get(TemplateTokenizer.class);
    private IContext ctx;
    private List<IParser> parsers = new ArrayList<IParser>();
    private int lastCursor = 0;

    public TemplateTokenizer(IContext context) {
        this.ctx = context;
        RythmEngine engine = this.ctx.getEngine();
        RythmConfiguration conf = engine.conf();
        if ((conf.smartEscapeEnabled() || conf.naturalTemplateEnabled()) && engine.extensionManager().hasTemplateLangs()) {
            this.parsers.add(new CodeTypeBlockStartSensor(this.ctx));
            this.parsers.add(new CodeTypeBlockEndSensor(this.ctx));
        }
        if (conf.naturalTemplateEnabled() && engine.extensionManager().hasTemplateLangs()) {
            this.parsers.add(new DirectiveCommentStartSensor(this.ctx));
            this.parsers.add(new DirectiveCommentEndSensor(this.ctx));
        }
        this.parsers.add(new ParserDispatcher(this.ctx));
        this.parsers.add(new BlockCloseParser(this.ctx));
        this.parsers.add(new ScriptParser(this.ctx));
        this.parsers.add(new StringTokenParser(this.ctx));
        this.parsers.add(new ParserBase(this.ctx){

            @Override
            public Token go() {
                TemplateParser p = (TemplateParser)this.ctx();
                if (TemplateTokenizer.this.lastCursor < p.cursor) {
                    return null;
                }
                String oneStep = p.getRemain().substring(0, 1);
                p.step(1);
                return new Token.StringToken(oneStep, p);
            }
        });
    }

    @Override
    public Iterator<Token> iterator() {
        return new Iterator<Token>(){

            @Override
            public boolean hasNext() {
                return TemplateTokenizer.this.ctx.hasRemain();
            }

            @Override
            public Token next() {
                for (IParser p : TemplateTokenizer.this.parsers) {
                    F.T2<IParser, Token> t2 = null;
                    Token t = p instanceof ParserDispatcher ? (null == (t2 = ((ParserDispatcher)p).go2()) ? null : (Token)t2._2) : p.go();
                    if (null == t) continue;
                    if (null != t2) {
                        p = (IParser)t2._1;
                    }
                    IContext ctx = p.ctx();
                    CodeBuilder cb = ctx.getCodeBuilder();
                    if (p instanceof IRemoveLeadingLineBreakAndSpaces) {
                        cb.removeSpaceToLastLineBreak(ctx);
                    } else if (p instanceof IRemoveLeadingSpacesIfLineBreak) {
                        cb.removeSpaceTillLastLineBreak(ctx);
                    }
                    TemplateTokenizer.this.lastCursor = ((TemplateParser)ctx).cursor;
                    return t;
                }
                throw new RuntimeException("Internal error");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

