/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.extension;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.I18N;

public interface IDateFormatFactory {
    public DateFormat createDateFormat(ITemplate var1, String var2, Locale var3, String var4);

    public static class DefaultDateFormatFactory
    implements IDateFormatFactory {
        public static final IDateFormatFactory INSTANCE = new DefaultDateFormatFactory();
        private ConcurrentMap<DateFormatKey, DateFormat> cache = new ConcurrentHashMap<DateFormatKey, DateFormat>();

        @Override
        public DateFormat createDateFormat(ITemplate template, String pattern, Locale locale, String timezone) {
            DateFormatKey key;
            DateFormat df;
            if (null == locale) {
                locale = I18N.locale(template);
            }
            if (null == (df = (DateFormat)this.cache.get(key = new DateFormatKey(locale, timezone, pattern)))) {
                df = null != pattern ? new SimpleDateFormat(pattern, locale) : DateFormat.getDateInstance(2, locale);
                if (null != timezone) {
                    df.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                this.cache.putIfAbsent(key, df);
            }
            return df;
        }
    }

    public static class DateFormatKey {
        private Locale locale;
        private String timezone;
        private String pattern;

        public DateFormatKey(Locale locale, String timezone, String pattern) {
            this.locale = locale;
            this.timezone = timezone;
            this.pattern = pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateFormatKey that = (DateFormatKey)o;
            return Objects.equals(this.locale, that.locale) && Objects.equals(this.timezone, that.timezone) && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.locale, this.timezone, this.pattern);
        }
    }
}

