/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.rythmengine.extension.ICacheService;

public enum EhCacheService implements ICacheService
{
    INSTANCE;

    CacheManager cacheManager;
    Cache cache;
    private static final String cacheName = "rythm";
    private int defaultTTL = 60;

    @Override
    public void put(String key, Serializable value, int ttl) {
        Element element = new Element((Serializable)((Object)key), value);
        if (0 >= ttl) {
            ttl = this.defaultTTL;
        }
        element.setTimeToLive(ttl);
        this.cache.put(element);
    }

    @Override
    public void put(String key, Serializable value) {
        this.put(key, value, this.defaultTTL);
    }

    @Override
    public Serializable remove(String key) {
        Serializable o = this.get(key);
        if (null == o) {
            return null;
        }
        this.cache.remove((Serializable)((Object)key));
        return o;
    }

    @Override
    public void evict(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    @Override
    public Serializable get(String key) {
        Element e = this.cache.get((Serializable)((Object)key));
        return null == e ? null : e.getValue();
    }

    @Override
    public boolean contains(String key) {
        Element e = this.cache.get((Serializable)((Object)key));
        return null != e;
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public void setDefaultTTL(int ttl) {
        if (ttl == 0) {
            throw new IllegalArgumentException("time to live value couldn't be zero");
        }
        this.defaultTTL = ttl;
    }

    @Override
    public void shutdown() {
        this.clear();
        this.cacheManager.shutdown();
    }

    @Override
    public void startup() {
        this.cacheManager = CacheManager.create();
        this.cacheManager.addCache(cacheName);
        this.cache = this.cacheManager.getCache(cacheName);
    }
}

