/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import javax.annotation.Nonnull;

public final class IgnoreCompletionFailures {
    private static final int RETRY_CNT = 10;

    private IgnoreCompletionFailures() {
    }

    private static boolean isCompletionFailure(@Nonnull Throwable t) {
        for (Class<?> c = t.getClass(); c != null; c = c.getSuperclass()) {
            if (!c.getName().endsWith("CompletionFailure")) continue;
            return true;
        }
        return false;
    }

    public static <R> R in(Fn0<R> action) {
        int cnt = 0;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static void inVoid(VoidFn0 action) {
        int cnt = 0;
        while (true) {
            try {
                action.call();
                return;
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static <R, T> R in(Fn1<R, T> action, T arg) {
        int cnt = 0;
        while (true) {
            try {
                return action.call(arg);
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static <T> void inVoid(VoidFn1<T> action, T arg) {
        int cnt = 0;
        while (true) {
            try {
                action.call(arg);
                return;
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static <R, T1, T2> R in(Fn2<R, T1, T2> action, T1 arg1, T2 arg2) {
        int cnt = 0;
        while (true) {
            try {
                return action.call(arg1, arg2);
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static <T1, T2> void inVoid(VoidFn2<T1, T2> action, T1 arg1, T2 arg2) {
        int cnt = 0;
        while (true) {
            try {
                action.call(arg1, arg2);
                return;
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static <R, T1, T2, T3> R in(Fn3<R, T1, T2, T3> action, T1 arg1, T2 arg2, T3 arg3) {
        int cnt = 0;
        while (true) {
            try {
                return action.call(arg1, arg2, arg3);
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    public static <T1, T2, T3> void inVoid(VoidFn3<T1, T2, T3> action, T1 arg1, T2 arg2, T3 arg3) {
        int cnt = 0;
        while (true) {
            try {
                action.call(arg1, arg2, arg3);
                return;
            }
            catch (Exception e) {
                Exception fail = e;
                if (cnt++ < 10 || IgnoreCompletionFailures.isCompletionFailure(fail)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    @FunctionalInterface
    public static interface VoidFn3<T1, T2, T3> {
        public void call(T1 var1, T2 var2, T3 var3) throws Exception;
    }

    @FunctionalInterface
    public static interface VoidFn2<T1, T2> {
        public void call(T1 var1, T2 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface VoidFn1<T> {
        public void call(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface VoidFn0 {
        public void call() throws Exception;
    }

    @FunctionalInterface
    public static interface Fn3<R, T1, T2, T3> {
        public R call(T1 var1, T2 var2, T3 var3) throws Exception;
    }

    @FunctionalInterface
    public static interface Fn2<R, T1, T2> {
        public R call(T1 var1, T2 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface Fn1<R, T> {
        public R call(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Fn0<R> {
        public R call() throws Exception;
    }
}

