/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.mavenplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactCollector;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateDependsFileMojo
extends AbstractMojo {
    protected static final String SEPARATOR = "/";
    protected MavenProject project;
    protected boolean recursive;
    private File outputFile;
    protected ArtifactRepository localRepo;
    protected List remoteRepos;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactResolver resolver;
    protected ArtifactCollector collector = new DefaultArtifactCollector();
    protected ArtifactFactory factory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        OutputStream out = null;
        try {
            ArrayList<Dependency> dependencies;
            this.outputFile.getParentFile().mkdirs();
            out = new FileOutputStream(this.outputFile);
            PrintStream printer = new PrintStream(out);
            if (!this.recursive) {
                dependencies = this.project.getDependencies();
            } else {
                Set artifacts = this.project.getArtifacts();
                dependencies = new ArrayList<Dependency>();
                for (Artifact a : artifacts) {
                    Dependency dep = new Dependency();
                    dep.setGroupId(a.getGroupId());
                    dep.setArtifactId(a.getArtifactId());
                    dep.setVersion(a.getBaseVersion());
                    dep.setClassifier(a.getClassifier());
                    dep.setType(a.getType());
                    dep.setScope(a.getScope());
                    dependencies.add(dep);
                }
            }
            Collections.sort(dependencies, new Comparator<Dependency>(){

                @Override
                public int compare(Dependency o1, Dependency o2) {
                    int result = o1.getGroupId().compareTo(o2.getGroupId());
                    if (result == 0 && (result = o1.getArtifactId().compareTo(o2.getArtifactId())) == 0 && (result = o1.getType().compareTo(o2.getType())) == 0) {
                        if (o1.getClassifier() == null) {
                            if (o2.getClassifier() != null) {
                                result = 1;
                            }
                        } else {
                            result = o2.getClassifier() != null ? o1.getClassifier().compareTo(o2.getClassifier()) : -1;
                        }
                        if (result == 0) {
                            result = o1.getVersion().compareTo(o2.getVersion());
                        }
                    }
                    return result;
                }
            });
            this.populateProperties(printer, dependencies);
            this.getLog().info((CharSequence)("Created: " + this.outputFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create dependencies file: " + e, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.getLog().info((CharSequence)("Failed to close: " + this.outputFile + ". Reason: " + e), (Throwable)e);
                }
            }
        }
    }

    protected void populateProperties(PrintStream out, List<Dependency> dependencies) {
        out.println("# Project dependencies generated by the Apache ServiceMix Maven Plugin");
        out.println("# Generated at: " + new Date());
        out.println();
        out.println("groupId = " + this.project.getGroupId());
        out.println("artifactId = " + this.project.getArtifactId());
        out.println("version = " + this.project.getVersion());
        out.println(this.project.getGroupId() + SEPARATOR + this.project.getArtifactId() + SEPARATOR + "version = " + this.project.getVersion());
        out.println();
        out.println("# dependencies");
        out.println();
        for (Dependency dependency : dependencies) {
            String prefix = dependency.getGroupId() + SEPARATOR + dependency.getArtifactId() + SEPARATOR;
            out.println(prefix + "version = " + dependency.getVersion());
            String classifier = dependency.getClassifier();
            if (classifier != null) {
                out.println(prefix + "classifier = " + classifier);
            }
            out.println(prefix + "type = " + dependency.getType());
            out.println(prefix + "scope = " + dependency.getScope());
            out.println();
            this.getLog().debug((CharSequence)("Dependency: " + dependency + " classifier: " + classifier + " type: " + dependency.getType()));
        }
    }
}

