/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.mvc.websocket.room;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.nutz.plugins.mvc.websocket.WsRoomProvider;

public class MemoryRoomProvider
implements WsRoomProvider {
    protected ConcurrentHashMap<String, ConcurrentSkipListSet<String>> rooms = new ConcurrentHashMap();

    @Override
    public Set<String> wsids(String room) {
        return this.getRoom(room);
    }

    @Override
    public void join(String room, String wsid) {
        this.getRoom(room).add(wsid);
    }

    @Override
    public void left(String room, String wsid) {
        this.getRoom(room).remove(wsid);
    }

    public Set<String> getRoom(String room) {
        ConcurrentSkipListSet<String> prev;
        ConcurrentSkipListSet<String> _room = this.rooms.get(room);
        if (_room == null && (prev = this.rooms.putIfAbsent(room, _room = new ConcurrentSkipListSet())) != null) {
            _room = prev;
        }
        return _room;
    }

    public Iterable<String> getRoomNames() {
        return new ArrayList<String>(this.rooms.keySet());
    }
}

