/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.time.Clock;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.value.ValueException;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.MultiDatabasesRoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RouteMessageRoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.RoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.SingleDatabaseRoutingProcedureRunner;
import org.neo4j.driver.internal.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.spi.Connection;

public class RoutingProcedureClusterCompositionProvider
implements ClusterCompositionProvider {
    private static final String PROTOCOL_ERROR_MESSAGE = "Failed to parse '%s' result received from server due to ";
    private final Clock clock;
    private final RoutingProcedureRunner singleDatabaseRoutingProcedureRunner;
    private final RoutingProcedureRunner multiDatabaseRoutingProcedureRunner;
    private final RoutingProcedureRunner routeMessageRoutingProcedureRunner;

    public RoutingProcedureClusterCompositionProvider(Clock clock, RoutingContext routingContext, Logging logging) {
        this(clock, new SingleDatabaseRoutingProcedureRunner(routingContext, logging), new MultiDatabasesRoutingProcedureRunner(routingContext, logging), new RouteMessageRoutingProcedureRunner(routingContext));
    }

    RoutingProcedureClusterCompositionProvider(Clock clock, SingleDatabaseRoutingProcedureRunner singleDatabaseRoutingProcedureRunner, MultiDatabasesRoutingProcedureRunner multiDatabaseRoutingProcedureRunner, RouteMessageRoutingProcedureRunner routeMessageRoutingProcedureRunner) {
        this.clock = clock;
        this.singleDatabaseRoutingProcedureRunner = singleDatabaseRoutingProcedureRunner;
        this.multiDatabaseRoutingProcedureRunner = multiDatabaseRoutingProcedureRunner;
        this.routeMessageRoutingProcedureRunner = routeMessageRoutingProcedureRunner;
    }

    @Override
    public CompletionStage<ClusterComposition> getClusterComposition(Connection connection, DatabaseName databaseName, Set<Bookmark> bookmarks, String impersonatedUser) {
        RoutingProcedureRunner runner = MultiDatabaseUtil.supportsRouteMessage(connection) ? this.routeMessageRoutingProcedureRunner : (MultiDatabaseUtil.supportsMultiDatabase(connection) ? this.multiDatabaseRoutingProcedureRunner : this.singleDatabaseRoutingProcedureRunner);
        return runner.run(connection, databaseName, bookmarks, impersonatedUser).thenApply(this::processRoutingResponse);
    }

    private ClusterComposition processRoutingResponse(RoutingProcedureResponse response) {
        ClusterComposition cluster;
        if (!response.isSuccess()) {
            throw new CompletionException(String.format("Failed to run '%s' on server. Please make sure that there is a Neo4j server or cluster up running.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)), response.error());
        }
        List<Record> records = response.records();
        long now = this.clock.millis();
        if (records.size() != 1) {
            throw new ProtocolException(String.format("Failed to parse '%s' result received from server due to records received '%s' is too few or too many.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response), records.size()));
        }
        try {
            cluster = ClusterComposition.parse(records.get(0), now);
        }
        catch (ValueException e) {
            throw new ProtocolException(String.format("Failed to parse '%s' result received from server due to unparsable record received.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)), e);
        }
        if (!cluster.hasRoutersAndReaders()) {
            throw new ProtocolException(String.format("Failed to parse '%s' result received from server due to no router or reader found in response.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)));
        }
        return cluster;
    }

    private static String invokedProcedureString(RoutingProcedureResponse response) {
        Query query = response.procedure();
        return query.text() + " " + query.parameters();
    }
}

