/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointIndex
implements INDArrayIndex {
    private static final Logger log = LoggerFactory.getLogger(PointIndex.class);
    private long point;
    private boolean initialized = false;

    private PointIndex() {
    }

    public PointIndex(long point) {
        this.point = point;
        this.initialized = point > 0L;
    }

    @Override
    public long end() {
        return this.point;
    }

    @Override
    public long offset() {
        return this.point;
    }

    @Override
    public long length() {
        return 1L;
    }

    @Override
    public long stride() {
        return 1L;
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean isInterval() {
        return false;
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
        this.point = begin < 0L ? (begin += arr.size(dimension)) : begin;
    }

    @Override
    public void init(INDArray arr, int dimension) {
        this.point = arr.size(dimension);
    }

    @Override
    public void init(long begin, long end, long max) {
        if (begin < 0L) {
            this.initialized = false;
            log.debug("Not initializing due to missing positive dimensions. Initialization will be attempted again during runtime.");
            return;
        }
        this.point = begin;
        this.initialized = true;
    }

    @Override
    public void init(long begin, long end) {
        if (begin < 0L) {
            this.initialized = false;
            log.debug("Not initializing due to missing positive dimensions. Initialization will be attempted again during runtime.");
            return;
        }
        this.point = begin;
        this.initialized = true;
    }

    @Override
    public boolean initialized() {
        return this.initialized && this.point >= 0L;
    }

    @Override
    public INDArrayIndex dup() {
        PointIndex pointIndex = new PointIndex();
        pointIndex.initialized = this.initialized;
        pointIndex.point = this.point;
        return pointIndex;
    }

    public String toString() {
        return "Point(" + this.point + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PointIndex)) {
            return false;
        }
        PointIndex other = (PointIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.point != other.point) {
            return false;
        }
        return this.initialized == other.initialized;
    }

    protected boolean canEqual(Object other) {
        return other instanceof PointIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $point = this.point;
        result = result * 59 + (int)($point >>> 32 ^ $point);
        result = result * 59 + (this.initialized ? 79 : 97);
        return result;
    }
}

