/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.compat.CompatSparseToDense;
import org.nd4j.linalg.api.ops.custom.Flatten;
import org.nd4j.linalg.api.ops.impl.controlflow.Where;
import org.nd4j.linalg.api.ops.impl.controlflow.WhereNumpy;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch;
import org.nd4j.linalg.api.ops.impl.indexaccum.custom.ArgMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.custom.ArgMin;
import org.nd4j.linalg.api.ops.impl.reduce.Mmul;
import org.nd4j.linalg.api.ops.impl.reduce.TensorMmul;
import org.nd4j.linalg.api.ops.impl.reduce.bool.All;
import org.nd4j.linalg.api.ops.impl.reduce.bool.Any;
import org.nd4j.linalg.api.ops.impl.reduce.custom.BatchMmul;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Mean;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Norm1;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Norm2;
import org.nd4j.linalg.api.ops.impl.reduce.floating.NormMax;
import org.nd4j.linalg.api.ops.impl.reduce.floating.SquaredNorm;
import org.nd4j.linalg.api.ops.impl.reduce.longer.MatchCondition;
import org.nd4j.linalg.api.ops.impl.reduce.same.Min;
import org.nd4j.linalg.api.ops.impl.reduce.same.Prod;
import org.nd4j.linalg.api.ops.impl.reduce.same.Sum;
import org.nd4j.linalg.api.ops.impl.reduce3.Dot;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMax;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMin;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterAdd;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterDiv;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMax;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMin;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMul;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterSub;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.ops.impl.shape.Concat;
import org.nd4j.linalg.api.ops.impl.shape.Create;
import org.nd4j.linalg.api.ops.impl.shape.CreateView;
import org.nd4j.linalg.api.ops.impl.shape.ExpandDims;
import org.nd4j.linalg.api.ops.impl.shape.Gather;
import org.nd4j.linalg.api.ops.impl.shape.GatherNd;
import org.nd4j.linalg.api.ops.impl.shape.Linspace;
import org.nd4j.linalg.api.ops.impl.shape.OneHot;
import org.nd4j.linalg.api.ops.impl.shape.OnesLike;
import org.nd4j.linalg.api.ops.impl.shape.Permute;
import org.nd4j.linalg.api.ops.impl.shape.Rank;
import org.nd4j.linalg.api.ops.impl.shape.Repeat;
import org.nd4j.linalg.api.ops.impl.shape.Reshape;
import org.nd4j.linalg.api.ops.impl.shape.SequenceMask;
import org.nd4j.linalg.api.ops.impl.shape.SetShape;
import org.nd4j.linalg.api.ops.impl.shape.Shape;
import org.nd4j.linalg.api.ops.impl.shape.Size;
import org.nd4j.linalg.api.ops.impl.shape.SizeAt;
import org.nd4j.linalg.api.ops.impl.shape.Slice;
import org.nd4j.linalg.api.ops.impl.shape.Split;
import org.nd4j.linalg.api.ops.impl.shape.SplitV;
import org.nd4j.linalg.api.ops.impl.shape.Squeeze;
import org.nd4j.linalg.api.ops.impl.shape.Stack;
import org.nd4j.linalg.api.ops.impl.shape.StridedSlice;
import org.nd4j.linalg.api.ops.impl.shape.Tile;
import org.nd4j.linalg.api.ops.impl.shape.Transpose;
import org.nd4j.linalg.api.ops.impl.shape.Unstack;
import org.nd4j.linalg.api.ops.impl.shape.ZerosLike;
import org.nd4j.linalg.api.ops.impl.summarystats.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.ops.impl.transforms.bool.MatchConditionTransform;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByNorm;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByValue;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndReplace;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndSet;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Assign;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CumProd;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CumSum;
import org.nd4j.linalg.api.ops.impl.transforms.custom.DynamicPartition;
import org.nd4j.linalg.api.ops.impl.transforms.custom.DynamicStitch;
import org.nd4j.linalg.api.ops.impl.transforms.custom.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Fill;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.InvertPermutation;
import org.nd4j.linalg.api.ops.impl.transforms.custom.IsNumericTensor;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Max;
import org.nd4j.linalg.api.ops.impl.transforms.custom.NotEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Reverse;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ReverseSequence;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentMax;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentMean;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentMin;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentProd;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentSum;
import org.nd4j.linalg.api.ops.impl.transforms.dtype.Cast;
import org.nd4j.linalg.api.ops.impl.transforms.dtype.MinMaxDataType;
import org.nd4j.linalg.api.ops.impl.transforms.same.Identity;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentMax;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentMean;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentMin;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentProd;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentSqrtN;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentSum;
import org.nd4j.linalg.api.ops.random.impl.Range;
import org.nd4j.linalg.factory.NDValidation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public class NDBase {
    public INDArray all(INDArray x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new All(x, dimensions));
    }

    public INDArray any(INDArray x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Any(x, dimensions));
    }

    public INDArray argmax(INDArray in, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("argmax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMax(in, keepDims, dimensions))[0];
    }

    public INDArray argmax(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("argmax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMax(in, false, dimensions))[0];
    }

    public INDArray argmin(INDArray in, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("argmin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMin(in, keepDims, dimensions))[0];
    }

    public INDArray argmin(INDArray in, int ... dimensions) {
        NDValidation.validateNumerical("argmin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new ArgMin(in, false, dimensions))[0];
    }

    public INDArray assign(INDArray x, INDArray y) {
        return Nd4j.exec(new Assign(x, y))[0];
    }

    public INDArray[] batchMmul(INDArray[] inputsA, INDArray[] inputsB, boolean transposeA, boolean transposeB) {
        NDValidation.validateNumerical("batchMmul", "inputsA", inputsA);
        Preconditions.checkArgument((inputsA.length >= 1 ? 1 : 0) != 0, (String)"inputsA has incorrect size/length. Expected: inputsA.length >= 1, got %s", (int)inputsA.length);
        NDValidation.validateNumerical("batchMmul", "inputsB", inputsB);
        Preconditions.checkArgument((inputsB.length >= 1 ? 1 : 0) != 0, (String)"inputsB has incorrect size/length. Expected: inputsB.length >= 1, got %s", (int)inputsB.length);
        return Nd4j.exec(new BatchMmul(inputsA, inputsB, transposeA, transposeB));
    }

    public INDArray[] batchMmul(INDArray[] inputsA, INDArray ... inputsB) {
        NDValidation.validateNumerical("batchMmul", "inputsA", inputsA);
        Preconditions.checkArgument((inputsA.length >= 1 ? 1 : 0) != 0, (String)"inputsA has incorrect size/length. Expected: inputsA.length >= 1, got %s", (int)inputsA.length);
        NDValidation.validateNumerical("batchMmul", "inputsB", inputsB);
        Preconditions.checkArgument((inputsB.length >= 1 ? 1 : 0) != 0, (String)"inputsB has incorrect size/length. Expected: inputsB.length >= 1, got %s", (int)inputsB.length);
        return Nd4j.exec(new BatchMmul(inputsA, inputsB, false, false));
    }

    public INDArray castTo(INDArray arg, DataType datatype) {
        return Nd4j.exec(new Cast(arg, datatype))[0];
    }

    public INDArray clipByNorm(INDArray x, double clipValue) {
        NDValidation.validateNumerical("clipByNorm", "x", x);
        return Nd4j.exec(new ClipByNorm(x, clipValue, new int[0]))[0];
    }

    public INDArray clipByNorm(INDArray x, INDArray clipValue, INDArray dimensions) {
        NDValidation.validateNumerical("clipByNorm", "x", x);
        NDValidation.validateNumerical("clipByNorm", "clipValue", clipValue);
        NDValidation.validateNumerical("clipByNorm", "dimensions", dimensions);
        return Nd4j.exec(new ClipByNorm(x, clipValue, dimensions))[0];
    }

    public INDArray clipByValue(INDArray x, double clipValueMin, double clipValueMax) {
        NDValidation.validateNumerical("clipByValue", "x", x);
        return Nd4j.exec(new ClipByValue(x, clipValueMin, clipValueMax))[0];
    }

    public INDArray clipByValue(INDArray x, INDArray clipValueMin, INDArray clipValueMax) {
        NDValidation.validateNumerical("clipByValue", "x", x);
        NDValidation.validateNumerical("clipByValue", "clipValueMin", clipValueMin);
        NDValidation.validateNumerical("clipByValue", "clipValueMax", clipValueMax);
        return Nd4j.exec(new ClipByValue(x, clipValueMin, clipValueMax))[0];
    }

    public INDArray concat(int dimension, INDArray ... inputs) {
        NDValidation.validateNumerical("concat", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        Preconditions.checkArgument((boolean)NDValidation.isSameType(inputs), (String)"Input arrays must all be the same datatype");
        return Nd4j.exec(new Concat(inputs, dimension))[0];
    }

    public INDArray create(INDArray shape, DataType dataType, String order, boolean initialize) {
        NDValidation.validateNumerical("create", "shape", shape);
        return Nd4j.exec(new Create(shape, dataType, order, initialize))[0];
    }

    public INDArray create(INDArray shape, DataType dataType) {
        NDValidation.validateNumerical("create", "shape", shape);
        return Nd4j.exec(new Create(shape, dataType, "c", false))[0];
    }

    public INDArray createView(INDArray input, INDArray ... indices) {
        Preconditions.checkArgument((indices.length >= 0 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 0, got %s", (int)indices.length);
        return Nd4j.exec(new CreateView(input, indices))[0];
    }

    public INDArray cumprod(INDArray in, boolean exclusive, boolean reverse, int ... axis) {
        NDValidation.validateNumerical("cumprod", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return Nd4j.exec(new CumProd(in, exclusive, reverse, axis))[0];
    }

    public INDArray cumprod(INDArray in, int ... axis) {
        NDValidation.validateNumerical("cumprod", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return Nd4j.exec(new CumProd(in, false, false, axis))[0];
    }

    public INDArray cumsum(INDArray in, boolean exclusive, boolean reverse, int ... axis) {
        NDValidation.validateNumerical("cumsum", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return Nd4j.exec(new CumSum(in, exclusive, reverse, axis))[0];
    }

    public INDArray cumsum(INDArray in, int ... axis) {
        NDValidation.validateNumerical("cumsum", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return Nd4j.exec(new CumSum(in, false, false, axis))[0];
    }

    public INDArray dot(INDArray x, INDArray y, int ... dimensions) {
        NDValidation.validateNumerical("dot", "x", x);
        NDValidation.validateNumerical("dot", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Dot(x, y, dimensions));
    }

    public INDArray[] dynamicPartition(INDArray x, INDArray partitions, int numPartitions) {
        NDValidation.validateNumerical("dynamicPartition", "x", x);
        NDValidation.validateInteger("dynamicPartition", "partitions", partitions);
        return Nd4j.exec(new DynamicPartition(x, partitions, numPartitions));
    }

    public INDArray dynamicStitch(INDArray[] indices, INDArray ... x) {
        NDValidation.validateInteger("dynamicStitch", "indices", indices);
        Preconditions.checkArgument((indices.length >= 1 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 1, got %s", (int)indices.length);
        NDValidation.validateNumerical("dynamicStitch", "x", x);
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (String)"x has incorrect size/length. Expected: x.length >= 1, got %s", (int)x.length);
        return Nd4j.exec(new DynamicStitch(indices, x))[0];
    }

    public INDArray eq(INDArray x, double y) {
        NDValidation.validateNumerical("eq", "x", x);
        return Nd4j.exec(new ScalarEquals(x, y));
    }

    public INDArray eq(INDArray x, INDArray y) {
        return Nd4j.exec(new EqualTo(x, y))[0];
    }

    public INDArray expandDims(INDArray x, int axis) {
        return Nd4j.exec(new ExpandDims(x, axis))[0];
    }

    public INDArray fill(INDArray shape, DataType dataType, double value) {
        NDValidation.validateInteger("fill", "shape", shape);
        return Nd4j.exec(new Fill(shape, dataType, value))[0];
    }

    public INDArray flatten(INDArray[] inputs, String order) {
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        return Nd4j.exec(new Flatten(inputs, order))[0];
    }

    public INDArray flatten(INDArray ... inputs) {
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        return Nd4j.exec(new Flatten(inputs, "c"))[0];
    }

    public INDArray gather(INDArray df, int[] indices, int axis) {
        Preconditions.checkArgument((indices.length >= 1 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 1, got %s", (int)indices.length);
        return Nd4j.exec(new Gather(df, indices, axis))[0];
    }

    public INDArray gather(INDArray df, INDArray indices, int axis) {
        NDValidation.validateInteger("gather", "indices", indices);
        return Nd4j.exec(new Gather(df, indices, axis))[0];
    }

    public INDArray gatherNd(INDArray df, INDArray indices) {
        NDValidation.validateNumerical("gatherNd", "indices", indices);
        return Nd4j.exec(new GatherNd(df, indices))[0];
    }

    public INDArray gt(INDArray x, double y) {
        return Nd4j.exec(new ScalarGreaterThan(x, y));
    }

    public INDArray gt(INDArray x, INDArray y) {
        return Nd4j.exec(new GreaterThan(x, y))[0];
    }

    public INDArray gte(INDArray x, double y) {
        return Nd4j.exec(new ScalarGreaterThanOrEqual(x, y));
    }

    public INDArray gte(INDArray x, INDArray y) {
        return Nd4j.exec(new GreaterThanOrEqual(x, y))[0];
    }

    public INDArray identity(INDArray input) {
        return Nd4j.exec(new Identity(input))[0];
    }

    public INDArray invertPermutation(INDArray input) {
        NDValidation.validateInteger("invertPermutation", "input", input);
        return Nd4j.exec(new InvertPermutation(input))[0];
    }

    public INDArray isNumericTensor(INDArray x) {
        NDValidation.validateNumerical("isNumericTensor", "x", x);
        return Nd4j.exec(new IsNumericTensor(x))[0];
    }

    public INDArray linspace(DataType dataType, double start, double stop, long number) {
        return Nd4j.exec(new Linspace(dataType, start, stop, number))[0];
    }

    public INDArray linspace(INDArray start, INDArray stop, INDArray number, DataType dataType) {
        NDValidation.validateNumerical("linspace", "start", start);
        NDValidation.validateNumerical("linspace", "stop", stop);
        NDValidation.validateInteger("linspace", "number", number);
        return Nd4j.exec(new Linspace(start, stop, number, dataType))[0];
    }

    public INDArray lt(INDArray x, double y) {
        return Nd4j.exec(new ScalarLessThan(x, y));
    }

    public INDArray lt(INDArray x, INDArray y) {
        return Nd4j.exec(new LessThan(x, y))[0];
    }

    public INDArray lte(INDArray x, double y) {
        return Nd4j.exec(new ScalarLessThanOrEqual(x, y));
    }

    public INDArray lte(INDArray x, INDArray y) {
        NDValidation.validateNumerical("lte", "x", x);
        NDValidation.validateNumerical("lte", "y", y);
        return Nd4j.exec(new LessThanOrEqual(x, y))[0];
    }

    public INDArray matchCondition(INDArray in, Condition condition) {
        NDValidation.validateNumerical("matchCondition", "in", in);
        return Nd4j.exec(new MatchConditionTransform(in, condition));
    }

    public INDArray matchConditionCount(INDArray in, Condition condition) {
        NDValidation.validateNumerical("matchConditionCount", "in", in);
        return Nd4j.exec(new MatchCondition(in, condition, new int[0]));
    }

    public INDArray matchConditionCount(INDArray in, Condition condition, boolean keepDim, int ... dimensions) {
        NDValidation.validateNumerical("matchConditionCount", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new MatchCondition(in, condition, keepDim, dimensions));
    }

    public INDArray matchConditionCount(INDArray in, Condition condition, int ... dimensions) {
        NDValidation.validateNumerical("matchConditionCount", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new MatchCondition(in, condition, false, dimensions));
    }

    public INDArray max(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("max", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new org.nd4j.linalg.api.ops.impl.reduce.same.Max(x, keepDims, dimensions));
    }

    public INDArray max(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("max", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new org.nd4j.linalg.api.ops.impl.reduce.same.Max(x, false, dimensions));
    }

    public INDArray max(INDArray first, INDArray second) {
        NDValidation.validateNumerical("max", "first", first);
        NDValidation.validateNumerical("max", "second", second);
        return Nd4j.exec(new Max(first, second))[0];
    }

    public INDArray mean(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("mean", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Mean(x, keepDims, dimensions));
    }

    public INDArray mean(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("mean", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Mean(x, false, dimensions));
    }

    public INDArray mean(INDArray x, INDArray dimensions, boolean keepDims) {
        NDValidation.validateNumerical("mean", "x", x);
        NDValidation.validateInteger("mean", "dimensions", dimensions);
        return Nd4j.exec(new Mean(x, dimensions, keepDims, new int[0]));
    }

    public INDArray mean(INDArray x, INDArray dimensions) {
        NDValidation.validateNumerical("mean", "x", x);
        NDValidation.validateInteger("mean", "dimensions", dimensions);
        return Nd4j.exec(new Mean(x, dimensions, false, new int[0]));
    }

    public INDArray merge(INDArray x, INDArray y) {
        return Nd4j.exec(new Merge(x, y))[0];
    }

    public INDArray min(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("min", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Min(x, keepDims, dimensions));
    }

    public INDArray min(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("min", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Min(x, false, dimensions));
    }

    public INDArray min(INDArray first, INDArray second) {
        NDValidation.validateNumerical("min", "first", first);
        NDValidation.validateNumerical("min", "second", second);
        return Nd4j.exec(new org.nd4j.linalg.api.ops.impl.transforms.custom.Min(first, second))[0];
    }

    public INDArray minMax(int datatype, int minOrMax) {
        return Nd4j.exec(new MinMaxDataType(datatype, minOrMax))[0];
    }

    public INDArray mmul(INDArray x, INDArray y, boolean transposeX, boolean transposeY, boolean transposeZ) {
        NDValidation.validateNumerical("mmul", "x", x);
        NDValidation.validateNumerical("mmul", "y", y);
        return Nd4j.exec(new Mmul(x, y, transposeX, transposeY, transposeZ))[0];
    }

    public INDArray mmul(INDArray x, INDArray y) {
        NDValidation.validateNumerical("mmul", "x", x);
        NDValidation.validateNumerical("mmul", "y", y);
        return Nd4j.exec(new Mmul(x, y, false, false, false))[0];
    }

    public INDArray neq(INDArray x, double y) {
        return Nd4j.exec(new ScalarNotEquals(x, y));
    }

    public INDArray neq(INDArray x, INDArray y) {
        return Nd4j.exec(new NotEqualTo(x, y))[0];
    }

    public INDArray norm1(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("norm1", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Norm1(x, keepDims, dimensions));
    }

    public INDArray norm1(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("norm1", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Norm1(x, false, dimensions));
    }

    public INDArray norm2(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("norm2", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Norm2(x, keepDims, dimensions));
    }

    public INDArray norm2(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("norm2", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Norm2(x, false, dimensions));
    }

    public INDArray normmax(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("normmax", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new NormMax(x, keepDims, dimensions));
    }

    public INDArray normmax(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("normmax", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new NormMax(x, false, dimensions));
    }

    public INDArray oneHot(INDArray indices, int depth, int axis, double on, double off, DataType dataType) {
        NDValidation.validateNumerical("oneHot", "indices", indices);
        return Nd4j.exec(new OneHot(indices, depth, axis, on, off, dataType))[0];
    }

    public INDArray oneHot(INDArray indices, int depth, int axis, double on, double off) {
        NDValidation.validateNumerical("oneHot", "indices", indices);
        return Nd4j.exec(new OneHot(indices, depth, axis, on, off, DataType.FLOAT))[0];
    }

    public INDArray oneHot(INDArray indices, int depth) {
        NDValidation.validateNumerical("oneHot", "indices", indices);
        return Nd4j.exec(new OneHot(indices, depth))[0];
    }

    public INDArray onesLike(INDArray input) {
        return Nd4j.exec(new OnesLike(input))[0];
    }

    public INDArray onesLike(INDArray input, DataType dataType) {
        return Nd4j.exec(new OnesLike(input, dataType))[0];
    }

    public INDArray permute(INDArray x, INDArray dimensions) {
        NDValidation.validateInteger("permute", "dimensions", dimensions);
        return Nd4j.exec(new Permute(x, dimensions, new int[0]))[0];
    }

    public INDArray permute(INDArray x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Permute(x, dimensions))[0];
    }

    public INDArray prod(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("prod", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Prod(x, keepDims, dimensions));
    }

    public INDArray prod(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("prod", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Prod(x, false, dimensions));
    }

    public INDArray prod(INDArray x, INDArray dimensions, boolean keepDims) {
        NDValidation.validateNumerical("prod", "x", x);
        NDValidation.validateInteger("prod", "dimensions", dimensions);
        return Nd4j.exec(new Prod(x, dimensions, keepDims, new int[0]));
    }

    public INDArray prod(INDArray x, INDArray dimensions) {
        NDValidation.validateNumerical("prod", "x", x);
        NDValidation.validateInteger("prod", "dimensions", dimensions);
        return Nd4j.exec(new Prod(x, dimensions, false, new int[0]));
    }

    public INDArray range(double from, double to, double step, DataType dataType) {
        return Nd4j.exec(new Range(from, to, step, dataType))[0];
    }

    public INDArray range(INDArray from, INDArray to, INDArray step, DataType dataType) {
        NDValidation.validateNumerical("range", "from", from);
        NDValidation.validateNumerical("range", "to", to);
        NDValidation.validateNumerical("range", "step", step);
        return Nd4j.exec(new Range(from, to, step, dataType))[0];
    }

    public INDArray rank(INDArray in) {
        return Nd4j.exec(new Rank(in))[0];
    }

    public INDArray repeat(INDArray input, INDArray repeats, int axis) {
        NDValidation.validateNumerical("repeat", "input", input);
        NDValidation.validateNumerical("repeat", "repeats", repeats);
        return Nd4j.exec(new Repeat(input, repeats, axis))[0];
    }

    public INDArray replaceWhere(INDArray update, INDArray from, Condition condition) {
        NDValidation.validateNumerical("replaceWhere", "update", update);
        NDValidation.validateNumerical("replaceWhere", "from", from);
        return Nd4j.exec(new CompareAndReplace(update, from, condition));
    }

    public INDArray replaceWhere(INDArray update, double value, Condition condition) {
        NDValidation.validateNumerical("replaceWhere", "update", update);
        return Nd4j.exec(new CompareAndSet(update, value, condition));
    }

    public INDArray reshape(INDArray x, INDArray shape) {
        NDValidation.validateNumerical("reshape", "shape", shape);
        return Nd4j.exec(new Reshape(x, shape))[0];
    }

    public INDArray reshape(INDArray x, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return Nd4j.exec(new Reshape(x, shape))[0];
    }

    public INDArray reverse(INDArray x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Reverse(x, dimensions))[0];
    }

    public INDArray reverseSequence(INDArray x, INDArray seq_lengths, int seqDim, int batchDim) {
        NDValidation.validateInteger("reverseSequence", "seq_lengths", seq_lengths);
        return Nd4j.exec(new ReverseSequence(x, seq_lengths, seqDim, batchDim))[0];
    }

    public INDArray reverseSequence(INDArray x, INDArray seq_lengths) {
        NDValidation.validateInteger("reverseSequence", "seq_lengths", seq_lengths);
        return Nd4j.exec(new ReverseSequence(x, seq_lengths, -1, 0))[0];
    }

    public INDArray scalarFloorMod(INDArray in, double value) {
        NDValidation.validateNumerical("scalarFloorMod", "in", in);
        return Nd4j.exec(new ScalarFMod(in, value));
    }

    public INDArray scalarMax(INDArray in, double value) {
        NDValidation.validateNumerical("scalarMax", "in", in);
        return Nd4j.exec(new ScalarMax(in, value));
    }

    public INDArray scalarMin(INDArray in, double value) {
        NDValidation.validateNumerical("scalarMin", "in", in);
        return Nd4j.exec(new ScalarMin(in, value));
    }

    public INDArray scalarSet(INDArray in, double set) {
        NDValidation.validateNumerical("scalarSet", "in", in);
        return Nd4j.exec(new ScalarSet(in, set));
    }

    public INDArray scatterAdd(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterAdd", "ref", ref);
        NDValidation.validateNumerical("scatterAdd", "indices", indices);
        NDValidation.validateNumerical("scatterAdd", "updates", updates);
        return Nd4j.exec(new ScatterAdd(ref, indices, updates))[0];
    }

    public INDArray scatterDiv(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterDiv", "ref", ref);
        NDValidation.validateNumerical("scatterDiv", "indices", indices);
        NDValidation.validateNumerical("scatterDiv", "updates", updates);
        return Nd4j.exec(new ScatterDiv(ref, indices, updates))[0];
    }

    public INDArray scatterMax(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterMax", "ref", ref);
        NDValidation.validateNumerical("scatterMax", "indices", indices);
        NDValidation.validateNumerical("scatterMax", "updates", updates);
        return Nd4j.exec(new ScatterMax(ref, indices, updates))[0];
    }

    public INDArray scatterMin(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterMin", "ref", ref);
        NDValidation.validateNumerical("scatterMin", "indices", indices);
        NDValidation.validateNumerical("scatterMin", "updates", updates);
        return Nd4j.exec(new ScatterMin(ref, indices, updates))[0];
    }

    public INDArray scatterMul(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterMul", "ref", ref);
        NDValidation.validateNumerical("scatterMul", "indices", indices);
        NDValidation.validateNumerical("scatterMul", "updates", updates);
        return Nd4j.exec(new ScatterMul(ref, indices, updates))[0];
    }

    public INDArray scatterSub(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterSub", "ref", ref);
        NDValidation.validateNumerical("scatterSub", "indices", indices);
        NDValidation.validateNumerical("scatterSub", "updates", updates);
        return Nd4j.exec(new ScatterSub(ref, indices, updates))[0];
    }

    public INDArray scatterUpdate(INDArray ref, INDArray indices, INDArray updates) {
        NDValidation.validateNumerical("scatterUpdate", "ref", ref);
        NDValidation.validateNumerical("scatterUpdate", "indices", indices);
        NDValidation.validateNumerical("scatterUpdate", "updates", updates);
        return Nd4j.exec(new ScatterUpdate(ref, indices, updates))[0];
    }

    public INDArray segmentMax(INDArray data, INDArray segmentIds) {
        NDValidation.validateNumerical("segmentMax", "segmentIds", segmentIds);
        return Nd4j.exec(new SegmentMax(data, segmentIds))[0];
    }

    public INDArray segmentMean(INDArray data, INDArray segmentIds) {
        NDValidation.validateNumerical("segmentMean", "segmentIds", segmentIds);
        return Nd4j.exec(new SegmentMean(data, segmentIds))[0];
    }

    public INDArray segmentMin(INDArray data, INDArray segmentIds) {
        NDValidation.validateNumerical("segmentMin", "segmentIds", segmentIds);
        return Nd4j.exec(new SegmentMin(data, segmentIds))[0];
    }

    public INDArray segmentProd(INDArray data, INDArray segmentIds) {
        NDValidation.validateNumerical("segmentProd", "segmentIds", segmentIds);
        return Nd4j.exec(new SegmentProd(data, segmentIds))[0];
    }

    public INDArray segmentSum(INDArray data, INDArray segmentIds) {
        NDValidation.validateNumerical("segmentSum", "segmentIds", segmentIds);
        return Nd4j.exec(new SegmentSum(data, segmentIds))[0];
    }

    public INDArray sequenceMask(INDArray lengths, int maxLen, DataType dataType) {
        NDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        return Nd4j.exec(new SequenceMask(lengths, maxLen, dataType))[0];
    }

    public INDArray sequenceMask(INDArray lengths, INDArray maxLen, DataType dataType) {
        NDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        NDValidation.validateInteger("sequenceMask", "maxLen", maxLen);
        return Nd4j.exec(new SequenceMask(lengths, maxLen, dataType))[0];
    }

    public INDArray sequenceMask(INDArray lengths, DataType dataType) {
        NDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        return Nd4j.exec(new SequenceMask(lengths, dataType))[0];
    }

    public INDArray[] setShape(INDArray input, INDArray shape) {
        NDValidation.validateNumerical("setShape", "input", input);
        NDValidation.validateNumerical("setShape", "shape", shape);
        return Nd4j.exec(new SetShape(input, shape));
    }

    public INDArray shape(INDArray input) {
        NDValidation.validateNumerical("shape", "input", input);
        return Nd4j.exec(new Shape(input))[0];
    }

    public INDArray size(INDArray in) {
        NDValidation.validateNumerical("size", "in", in);
        return Nd4j.exec(new Size(in))[0];
    }

    public INDArray sizeAt(INDArray in, int dimension) {
        NDValidation.validateNumerical("sizeAt", "in", in);
        return Nd4j.exec(new SizeAt(in, dimension))[0];
    }

    public INDArray slice(INDArray input, int[] begin, int ... size) {
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((size.length >= 1 ? 1 : 0) != 0, (String)"size has incorrect size/length. Expected: size.length >= 1, got %s", (int)size.length);
        return Nd4j.exec(new Slice(input, begin, size))[0];
    }

    public INDArray slice(INDArray input, INDArray begin, INDArray size) {
        NDValidation.validateInteger("slice", "begin", begin);
        NDValidation.validateInteger("slice", "size", size);
        return Nd4j.exec(new Slice(input, begin, size))[0];
    }

    public INDArray sparseToDense(INDArray indices, INDArray shape, INDArray values) {
        NDValidation.validateNumerical("sparseToDense", "indices", indices);
        NDValidation.validateNumerical("sparseToDense", "shape", shape);
        NDValidation.validateNumerical("sparseToDense", "values", values);
        return Nd4j.exec(new CompatSparseToDense(indices, shape, values))[0];
    }

    public INDArray sparseToDense(INDArray indices, INDArray shape, INDArray values, INDArray defaultValue) {
        NDValidation.validateNumerical("sparseToDense", "indices", indices);
        NDValidation.validateNumerical("sparseToDense", "shape", shape);
        NDValidation.validateNumerical("sparseToDense", "values", values);
        NDValidation.validateNumerical("sparseToDense", "defaultValue", defaultValue);
        return Nd4j.exec(new CompatSparseToDense(indices, shape, values, defaultValue))[0];
    }

    public INDArray[] split(INDArray input, int numSplit, int splitDim) {
        return Nd4j.exec(new Split(input, numSplit, splitDim));
    }

    public INDArray[] split(INDArray input, INDArray numSplit, int splitDim) {
        NDValidation.validateNumerical("split", "input", input);
        NDValidation.validateNumerical("split", "numSplit", numSplit);
        return Nd4j.exec(new Split(input, numSplit, splitDim));
    }

    public INDArray[] splitV(INDArray input, INDArray sizes, int numSplit, int splitDim) {
        return Nd4j.exec(new SplitV(input, sizes, numSplit, splitDim));
    }

    public INDArray squaredNorm(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("squaredNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new SquaredNorm(x, keepDims, dimensions));
    }

    public INDArray squaredNorm(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("squaredNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new SquaredNorm(x, false, dimensions));
    }

    public INDArray squeeze(INDArray x, int axis) {
        NDValidation.validateNumerical("squeeze", "x", x);
        return Nd4j.exec(new Squeeze(x, axis))[0];
    }

    public INDArray stack(int axis, INDArray ... values) {
        Preconditions.checkArgument((values.length >= 1 ? 1 : 0) != 0, (String)"values has incorrect size/length. Expected: values.length >= 1, got %s", (int)values.length);
        return Nd4j.exec(new Stack(values, axis))[0];
    }

    public INDArray standardDeviation(INDArray x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("standardDeviation", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new StandardDeviation(x, biasCorrected, keepDims, dimensions));
    }

    public INDArray standardDeviation(INDArray x, boolean biasCorrected, int ... dimensions) {
        NDValidation.validateNumerical("standardDeviation", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new StandardDeviation(x, biasCorrected, false, dimensions));
    }

    public INDArray stridedSlice(INDArray in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((end.length >= 1 ? 1 : 0) != 0, (String)"end has incorrect size/length. Expected: end.length >= 1, got %s", (int)end.length);
        Preconditions.checkArgument((strides.length >= 1 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length >= 1, got %s", (int)strides.length);
        return Nd4j.exec(new StridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask))[0];
    }

    public INDArray stridedSlice(INDArray in, long[] begin, long[] end, long ... strides) {
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((end.length >= 1 ? 1 : 0) != 0, (String)"end has incorrect size/length. Expected: end.length >= 1, got %s", (int)end.length);
        Preconditions.checkArgument((strides.length >= 1 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length >= 1, got %s", (int)strides.length);
        return Nd4j.exec(new StridedSlice(in, begin, end, strides, 0, 0, 0, 0, 0))[0];
    }

    public INDArray stridedSlice(INDArray in, INDArray begin, INDArray end, INDArray strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        NDValidation.validateNumerical("stridedSlice", "begin", begin);
        NDValidation.validateNumerical("stridedSlice", "end", end);
        NDValidation.validateNumerical("stridedSlice", "strides", strides);
        return Nd4j.exec(new StridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask))[0];
    }

    public INDArray stridedSlice(INDArray in, INDArray begin, INDArray end, INDArray strides) {
        NDValidation.validateNumerical("stridedSlice", "begin", begin);
        NDValidation.validateNumerical("stridedSlice", "end", end);
        NDValidation.validateNumerical("stridedSlice", "strides", strides);
        return Nd4j.exec(new StridedSlice(in, begin, end, strides, 0, 0, 0, 0, 0))[0];
    }

    public INDArray sum(INDArray x, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("sum", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Sum(x, keepDims, dimensions));
    }

    public INDArray sum(INDArray x, int ... dimensions) {
        NDValidation.validateNumerical("sum", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Sum(x, false, dimensions));
    }

    public INDArray[] switchOp(INDArray x, INDArray predicate) {
        NDValidation.validateBool("switchOp", "predicate", predicate);
        return Nd4j.exec(new Switch(x, predicate));
    }

    public INDArray tensorMmul(INDArray x, INDArray y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        NDValidation.validateNumerical("tensorMmul", "x", x);
        NDValidation.validateNumerical("tensorMmul", "y", y);
        Preconditions.checkArgument((dimensionsX.length >= 1 ? 1 : 0) != 0, (String)"dimensionsX has incorrect size/length. Expected: dimensionsX.length >= 1, got %s", (int)dimensionsX.length);
        Preconditions.checkArgument((dimensionsY.length >= 1 ? 1 : 0) != 0, (String)"dimensionsY has incorrect size/length. Expected: dimensionsY.length >= 1, got %s", (int)dimensionsY.length);
        return Nd4j.exec(new TensorMmul(x, y, dimensionsX, dimensionsY, transposeX, transposeY, transposeZ))[0];
    }

    public INDArray tensorMmul(INDArray x, INDArray y, int[] dimensionsX, int ... dimensionsY) {
        NDValidation.validateNumerical("tensorMmul", "x", x);
        NDValidation.validateNumerical("tensorMmul", "y", y);
        Preconditions.checkArgument((dimensionsX.length >= 1 ? 1 : 0) != 0, (String)"dimensionsX has incorrect size/length. Expected: dimensionsX.length >= 1, got %s", (int)dimensionsX.length);
        Preconditions.checkArgument((dimensionsY.length >= 1 ? 1 : 0) != 0, (String)"dimensionsY has incorrect size/length. Expected: dimensionsY.length >= 1, got %s", (int)dimensionsY.length);
        return Nd4j.exec(new TensorMmul(x, y, dimensionsX, dimensionsY, false, false, false))[0];
    }

    public INDArray tile(INDArray x, INDArray repeat) {
        NDValidation.validateInteger("tile", "repeat", repeat);
        return Nd4j.exec(new Tile(x, repeat))[0];
    }

    public INDArray tile(INDArray x, int ... repeat) {
        Preconditions.checkArgument((repeat.length >= 1 ? 1 : 0) != 0, (String)"repeat has incorrect size/length. Expected: repeat.length >= 1, got %s", (int)repeat.length);
        return Nd4j.exec(new Tile(x, repeat))[0];
    }

    public INDArray transpose(INDArray x) {
        return Nd4j.exec(new Transpose(x))[0];
    }

    public INDArray unsortedSegmentMax(INDArray data, INDArray segmentIds, int numSegments) {
        NDValidation.validateNumerical("unsortedSegmentMax", "data", data);
        NDValidation.validateNumerical("unsortedSegmentMax", "segmentIds", segmentIds);
        return Nd4j.exec(new UnsortedSegmentMax(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentMax(INDArray data, INDArray segmentIds, INDArray numSegments) {
        NDValidation.validateNumerical("unsortedSegmentMax", "data", data);
        NDValidation.validateNumerical("unsortedSegmentMax", "segmentIds", segmentIds);
        NDValidation.validateInteger("unsortedSegmentMax", "numSegments", numSegments);
        return Nd4j.exec(new UnsortedSegmentMax(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentMean(INDArray data, INDArray segmentIds, int numSegments) {
        NDValidation.validateNumerical("unsortedSegmentMean", "data", data);
        NDValidation.validateNumerical("unsortedSegmentMean", "segmentIds", segmentIds);
        return Nd4j.exec(new UnsortedSegmentMean(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentMean(INDArray data, INDArray segmentIds, INDArray numSegments) {
        NDValidation.validateNumerical("unsortedSegmentMean", "data", data);
        NDValidation.validateNumerical("unsortedSegmentMean", "segmentIds", segmentIds);
        NDValidation.validateInteger("unsortedSegmentMean", "numSegments", numSegments);
        return Nd4j.exec(new UnsortedSegmentMean(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentMin(INDArray data, INDArray segmentIds, int numSegments) {
        NDValidation.validateNumerical("unsortedSegmentMin", "data", data);
        NDValidation.validateNumerical("unsortedSegmentMin", "segmentIds", segmentIds);
        return Nd4j.exec(new UnsortedSegmentMin(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentMin(INDArray data, INDArray segmentIds, INDArray numSegments) {
        NDValidation.validateNumerical("unsortedSegmentMin", "data", data);
        NDValidation.validateNumerical("unsortedSegmentMin", "segmentIds", segmentIds);
        NDValidation.validateInteger("unsortedSegmentMin", "numSegments", numSegments);
        return Nd4j.exec(new UnsortedSegmentMin(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentProd(INDArray data, INDArray segmentIds, int numSegments) {
        NDValidation.validateNumerical("unsortedSegmentProd", "data", data);
        NDValidation.validateNumerical("unsortedSegmentProd", "segmentIds", segmentIds);
        return Nd4j.exec(new UnsortedSegmentProd(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentProd(INDArray data, INDArray segmentIds, INDArray numSegments) {
        NDValidation.validateNumerical("unsortedSegmentProd", "data", data);
        NDValidation.validateNumerical("unsortedSegmentProd", "segmentIds", segmentIds);
        NDValidation.validateInteger("unsortedSegmentProd", "numSegments", numSegments);
        return Nd4j.exec(new UnsortedSegmentProd(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentSqrtN(INDArray data, INDArray segmentIds, int numSegments) {
        NDValidation.validateNumerical("unsortedSegmentSqrtN", "data", data);
        NDValidation.validateNumerical("unsortedSegmentSqrtN", "segmentIds", segmentIds);
        return Nd4j.exec(new UnsortedSegmentSqrtN(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentSqrtN(INDArray data, INDArray segmentIds, INDArray numSegments) {
        NDValidation.validateNumerical("unsortedSegmentSqrtN", "data", data);
        NDValidation.validateNumerical("unsortedSegmentSqrtN", "segmentIds", segmentIds);
        NDValidation.validateInteger("unsortedSegmentSqrtN", "numSegments", numSegments);
        return Nd4j.exec(new UnsortedSegmentSqrtN(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentSum(INDArray data, INDArray segmentIds, int numSegments) {
        NDValidation.validateNumerical("unsortedSegmentSum", "data", data);
        NDValidation.validateNumerical("unsortedSegmentSum", "segmentIds", segmentIds);
        return Nd4j.exec(new UnsortedSegmentSum(data, segmentIds, numSegments))[0];
    }

    public INDArray unsortedSegmentSum(INDArray data, INDArray segmentIds, INDArray numSegments) {
        NDValidation.validateNumerical("unsortedSegmentSum", "data", data);
        NDValidation.validateNumerical("unsortedSegmentSum", "segmentIds", segmentIds);
        NDValidation.validateInteger("unsortedSegmentSum", "numSegments", numSegments);
        return Nd4j.exec(new UnsortedSegmentSum(data, segmentIds, numSegments))[0];
    }

    public INDArray[] unstack(INDArray value, int axis, int num) {
        return Nd4j.exec(new Unstack(value, axis, num));
    }

    public INDArray variance(INDArray x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        NDValidation.validateNumerical("variance", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Variance(x, biasCorrected, keepDims, dimensions));
    }

    public INDArray variance(INDArray x, boolean biasCorrected, int ... dimensions) {
        NDValidation.validateNumerical("variance", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return Nd4j.exec(new Variance(x, biasCorrected, false, dimensions));
    }

    public INDArray where(INDArray x, INDArray y, INDArray condition) {
        NDValidation.validateBool("where", "condition", condition);
        return Nd4j.exec(new Where(x, y, condition))[0];
    }

    public INDArray where(INDArray x, INDArray condition) {
        NDValidation.validateNumerical("where", "x", x);
        NDValidation.validateBool("where", "condition", condition);
        return Nd4j.exec(new Where(x, condition))[0];
    }

    public INDArray where(INDArray condition) {
        NDValidation.validateBool("where", "condition", condition);
        return Nd4j.exec(new Where(condition))[0];
    }

    public INDArray whereNumpy(INDArray x, INDArray y, INDArray condition) {
        NDValidation.validateNumerical("whereNumpy", "condition", condition);
        return Nd4j.exec(new WhereNumpy(x, y, condition))[0];
    }

    public INDArray zerosLike(INDArray input) {
        return Nd4j.exec(new ZerosLike(input))[0];
    }
}

