/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mydotey.java.StringExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkInterfaceManager {
    private static Logger _logger = LoggerFactory.getLogger(NetworkInterfaceManager.class);
    public static final NetworkInterfaceManager INSTANCE = new NetworkInterfaceManager();
    private String _hostIP = StringExtension.trim(System.getProperty("host.ip"));
    private String _hostName = StringExtension.trim(System.getProperty("host.name"));

    private NetworkInterfaceManager() {
        InetAddress localIP = null;
        try {
            localIP = this.getLocalIP();
        }
        catch (Throwable ex) {
            _logger.error("IPv4 address or local hostName auto find failed!", ex);
        }
        if (StringExtension.isBlank(this._hostIP) && localIP != null) {
            this._hostIP = localIP.getHostAddress();
        }
        if (StringExtension.isBlank(this._hostName)) {
            try {
                this._hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable ex) {
                _logger.error("Cannot get hostName from InetAddress.getLocalHost().", ex);
            }
        }
        if (StringExtension.isBlank(this._hostName) && localIP != null) {
            this._hostName = localIP.getHostName();
        }
        if (StringExtension.isBlank(this._hostName)) {
            this._hostName = this._hostIP;
        }
        _logger.info("{} use: { hostIP: {}, hostName: {} }", new Object[]{NetworkInterfaceManager.class.getSimpleName(), this._hostIP, this._hostName});
    }

    public String hostIP() {
        if (this._hostIP == null) {
            throw new RuntimeException("Cannot find local ipv4 address!");
        }
        return this._hostIP;
    }

    public String hostName() {
        if (this._hostName == null) {
            throw new RuntimeException("Cannot find local hostName!");
        }
        return this._hostName;
    }

    private InetAddress getLocalIP() throws SocketException, UnknownHostException {
        ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
        ArrayList<Inet4Address> ipV4Addresses = new ArrayList<Inet4Address>();
        try {
            for (NetworkInterface ni : nis) {
                if (!ni.isUp() || ni.isLoopback() || ni.isVirtual()) continue;
                ArrayList<InetAddress> list = Collections.list(ni.getInetAddresses());
                for (InetAddress address : list) {
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    ipV4Addresses.add((Inet4Address)address);
                }
            }
        }
        catch (Throwable ex) {
            _logger.error("Get local ip failed", ex);
        }
        InetAddress address = this.getValidIPv4(ipV4Addresses);
        if (address == null) {
            address = InetAddress.getLocalHost();
        }
        return address;
    }

    private Inet4Address getValidIPv4(List<Inet4Address> addresses) {
        Inet4Address valid = null;
        int maxWeight = -1;
        for (Inet4Address address : addresses) {
            int weight = 0;
            if (!address.getHostName().equals(address.getHostAddress())) {
                ++weight;
            }
            if (address.isLinkLocalAddress()) {
                weight += 4;
            }
            if (address.isSiteLocalAddress()) {
                weight += 8;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            valid = address;
        }
        return valid;
    }
}

