/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.java.function;

import java.util.Objects;
import java.util.function.Supplier;

public class SingletonSupplier<T>
implements Supplier<T> {
    private volatile T _value;
    private Supplier<T> _supplier;

    public SingletonSupplier(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        this._supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this._value == null) {
            SingletonSupplier singletonSupplier = this;
            synchronized (singletonSupplier) {
                if (this._value == null) {
                    this._value = this._supplier.get();
                    if (this._value == null) {
                        throw new IllegalStateException("SingletonSupplier got null from the source supplier: " + this._supplier);
                    }
                    this._supplier = null;
                }
            }
        }
        return this._value;
    }
}

