/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.util;

public class TimeSequenceCircularBufferConfig
implements Cloneable {
    private long _timeWindow;
    private long _bucketTtl;
    private int _bucketCount;

    protected TimeSequenceCircularBufferConfig() {
    }

    public long getTimeWindow() {
        return this._timeWindow;
    }

    public long getBucketTtl() {
        return this._bucketTtl;
    }

    public int getBucketCount() {
        return this._bucketCount;
    }

    public TimeSequenceCircularBufferConfig clone() {
        try {
            return (TimeSequenceCircularBufferConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return String.format("%s { timeWindow: %s, bucketTtl: %s, bucketCount: %s }", this.getClass().getSimpleName(), this._timeWindow, this._bucketTtl, this._bucketCount);
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private TimeSequenceCircularBufferConfig _config = this.newConfig();

        protected AbstractBuilder() {
        }

        protected TimeSequenceCircularBufferConfig newConfig() {
            return new TimeSequenceCircularBufferConfig();
        }

        protected TimeSequenceCircularBufferConfig getConfig() {
            return this._config;
        }

        public B setTimeWindow(long timeWindow) {
            this._config._timeWindow = timeWindow;
            return (B)this;
        }

        public B setBucketTtl(long bucketTtl) {
            this._config._bucketTtl = bucketTtl;
            return (B)this;
        }

        public TimeSequenceCircularBufferConfig build() {
            if (this._config._timeWindow <= 0L) {
                throw new IllegalArgumentException("timeWindow not set");
            }
            if (this._config._bucketTtl <= 0L) {
                throw new IllegalArgumentException("bucketTtl not set");
            }
            if (this._config._timeWindow % this._config._bucketTtl != 0L) {
                throw new IllegalArgumentException(String.format("timeWindow %s cannot be divided by bucketTtl %s.", this._config._timeWindow, this._config._bucketTtl));
            }
            long bucketCount = this._config._timeWindow / this._config._bucketTtl;
            if (bucketCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(String.format("timeWindow %s too large", this._config._timeWindow));
            }
            this._config._bucketCount = (int)bucketCount;
            return this._config.clone();
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
    }
}

