/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.util;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.mydotey.util.TimeBucket;
import org.mydotey.util.TimeSequenceCircularBufferConfig;

public abstract class TimeSequenceCircularBuffer<T extends TimeBucket> {
    private Object[] _buckets;
    private TimeSequenceCircularBufferConfig _bufferConfig;
    private ReentrantLock _addBucketLock = new ReentrantLock();
    private volatile int _bufferEnd;
    private volatile T _spareBucket;

    protected TimeSequenceCircularBuffer(TimeSequenceCircularBufferConfig bufferConfig) {
        Objects.requireNonNull(bufferConfig, "bufferConfig is null");
        this._bufferConfig = bufferConfig;
        this._buckets = new Object[this._bufferConfig.getBucketCount() + 1];
        for (int i = 0; i < this._buckets.length; ++i) {
            this._buckets[i] = this.newBucket(0L, this._bufferConfig.getTimeWindow());
        }
        this._spareBucket = this.newBucket(0L, this._bufferConfig.getTimeWindow());
    }

    public TimeSequenceCircularBufferConfig getConfig() {
        return this._bufferConfig;
    }

    protected abstract T newBucket(long var1, long var3);

    protected void forEach(Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "consumer is null");
        for (Object item : this._buckets) {
            TimeBucket bucket = (TimeBucket)item;
            if (bucket.isStale()) continue;
            consumer.accept(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getCurrentBucket() {
        long currentBucketStartTime = this.getCurrentBucketStartTime();
        if (!this.needRefreshCurrentBucket(currentBucketStartTime)) {
            return (T)((TimeBucket)this._buckets[this._bufferEnd]);
        }
        if (!this._addBucketLock.tryLock()) {
            return (T)((TimeBucket)this._buckets[this._bufferEnd]);
        }
        try {
            currentBucketStartTime = this.getCurrentBucketStartTime();
            if (!this.needRefreshCurrentBucket(currentBucketStartTime)) {
                TimeBucket timeBucket = (TimeBucket)this._buckets[this._bufferEnd];
                return (T)timeBucket;
            }
            int newBufferEnd = (this._bufferEnd + 1) % this._buckets.length;
            TimeBucket oldBucket = (TimeBucket)this._buckets[newBufferEnd];
            ((TimeBucket)this._spareBucket).reset(currentBucketStartTime);
            this._buckets[newBufferEnd] = this._spareBucket;
            this._bufferEnd = newBufferEnd;
            oldBucket.reset(0L);
            this._spareBucket = oldBucket;
            TimeBucket timeBucket = (TimeBucket)this._buckets[this._bufferEnd];
            return (T)timeBucket;
        }
        finally {
            this._addBucketLock.unlock();
        }
    }

    private long getCurrentBucketStartTime() {
        long currentTime = System.currentTimeMillis();
        return currentTime - currentTime % this._bufferConfig.getBucketTtl();
    }

    private boolean needRefreshCurrentBucket(long currentBucketStartTime) {
        return ((TimeBucket)this._buckets[this._bufferEnd]).getStartTime() + this._bufferConfig.getBucketTtl() <= currentBucketStartTime;
    }
}

