/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.util;

import java.util.Objects;
import java.util.function.Consumer;
import org.mydotey.util.DataBucket;
import org.mydotey.util.DataBufferConfig;
import org.mydotey.util.TimeSequenceCircularBuffer;

public class DataBuffer<T>
extends TimeSequenceCircularBuffer<DataBucket<T>> {
    public DataBuffer(DataBufferConfig bufferConfig) {
        super(bufferConfig);
    }

    @Override
    public DataBufferConfig getConfig() {
        return (DataBufferConfig)super.getConfig();
    }

    @Override
    protected DataBucket<T> newBucket(long startTime, long ttl) {
        return new DataBucket(startTime, ttl, this.getConfig().getBucketCapacity());
    }

    public void add(T data) {
        ((DataBucket)this.getCurrentBucket()).add(data);
    }

    public void consume(Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "consumer is null");
        this.forEach(bucket -> {
            for (int i = 0; i < bucket.count(); ++i) {
                Object item = bucket.get(i);
                if (item == null) continue;
                consumer.accept(item);
            }
        });
    }
}

