/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.mydotey.util.TimeBucket;

public class DataBucket<T>
extends TimeBucket {
    private final Object[] _data;
    private final AtomicInteger _count;

    public DataBucket(long startTime, long ttl, int capacity) {
        super(startTime, ttl);
        this._data = new Object[capacity];
        this._count = new AtomicInteger();
    }

    public int count() {
        return Math.min(this._count.get(), this._data.length);
    }

    public void add(T value) {
        if (this._data.length == 0) {
            return;
        }
        if (value == null) {
            return;
        }
        int index = this._count.getAndIncrement() % this._data.length;
        this._data[index] = value;
    }

    public T get(int index) {
        return (T)this._data[index];
    }

    @Override
    public void reset(long startTime) {
        super.reset(startTime);
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = null;
        }
        this._count.set(0);
    }
}

