/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.util;

import java.util.concurrent.atomic.AtomicLong;
import org.mydotey.util.CounterBucket;
import org.mydotey.util.TimeSequenceCircularBuffer;
import org.mydotey.util.TimeSequenceCircularBufferConfig;

public class CounterBuffer<T>
extends TimeSequenceCircularBuffer<CounterBucket<T>> {
    public CounterBuffer(TimeSequenceCircularBufferConfig bufferConfig) {
        super(bufferConfig);
    }

    @Override
    protected CounterBucket<T> newBucket(long startTime, long ttl) {
        return new CounterBucket(startTime, ttl);
    }

    public long get(T identity) {
        AtomicLong count = new AtomicLong();
        this.forEach(bucket -> count.addAndGet(bucket.get(identity)));
        return count.get();
    }

    public void increment(T identity) {
        ((CounterBucket)this.getCurrentBucket()).increment(identity);
    }

    public void decrement(T identity) {
        ((CounterBucket)this.getCurrentBucket()).decrement(identity);
    }
}

