/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.util;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.mydotey.util.TimeBucket;

public class CounterBucket<T>
extends TimeBucket {
    protected static final Function<Object, AtomicLong> COUNTER_CREATOR = k -> new AtomicLong();
    private final ConcurrentHashMap<T, AtomicLong> _counters = new ConcurrentHashMap();

    public CounterBucket(long startTime, long ttl) {
        super(startTime, ttl);
    }

    public long get(T identity) {
        Objects.requireNonNull(identity, "identity is null");
        AtomicLong counter = this._counters.get(identity);
        return counter == null ? 0L : counter.get();
    }

    public void increment(T identity) {
        Objects.requireNonNull(identity, "identity is null");
        AtomicLong counter = this.getCounter(identity);
        counter.incrementAndGet();
    }

    public void decrement(T identity) {
        Objects.requireNonNull(identity, "identity is null");
        AtomicLong counter = this.getCounter(identity);
        counter.decrementAndGet();
    }

    private AtomicLong getCounter(T identity) {
        return this._counters.computeIfAbsent(identity, COUNTER_CREATOR);
    }

    @Override
    public void reset(long startTime) {
        super.reset(startTime);
        this._counters.clear();
    }
}

