/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.UnwindOptions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Aggregates {
    public static Bson match(Bson filter) {
        return new SimplePipelineStage("$match", filter);
    }

    public static Bson project(Bson projection) {
        return new SimplePipelineStage("$project", projection);
    }

    public static Bson sort(Bson sort) {
        return new SimplePipelineStage("$sort", sort);
    }

    public static Bson skip(int skip) {
        return new BsonDocument("$skip", (BsonValue)new BsonInt32(skip));
    }

    public static Bson limit(int limit) {
        return new BsonDocument("$limit", (BsonValue)new BsonInt32(limit));
    }

    public static Bson lookup(String from, String localField, String foreignField, String as) {
        return new BsonDocument("$lookup", (BsonValue)new BsonDocument("from", (BsonValue)new BsonString(from)).append("localField", (BsonValue)new BsonString(localField)).append("foreignField", (BsonValue)new BsonString(foreignField)).append("as", (BsonValue)new BsonString(as)));
    }

    public static <TExpression> Bson group(TExpression id, BsonField ... fieldAccumulators) {
        return Aggregates.group(id, Arrays.asList(fieldAccumulators));
    }

    public static <TExpression> Bson group(final TExpression id, final List<BsonField> fieldAccumulators) {
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
                writer.writeStartDocument();
                writer.writeStartDocument("$group");
                writer.writeName("_id");
                BuildersHelper.encodeValue(writer, id, codecRegistry);
                for (BsonField fieldAccumulator : fieldAccumulators) {
                    writer.writeName(fieldAccumulator.getName());
                    BuildersHelper.encodeValue(writer, fieldAccumulator.getValue(), codecRegistry);
                }
                writer.writeEndDocument();
                writer.writeEndDocument();
                return writer.getDocument();
            }
        };
    }

    public static Bson unwind(String fieldName) {
        return new BsonDocument("$unwind", (BsonValue)new BsonString(fieldName));
    }

    public static Bson unwind(String fieldName, UnwindOptions unwindOptions) {
        Assertions.notNull((String)"unwindOptions", (Object)unwindOptions);
        BsonDocument options = new BsonDocument("path", (BsonValue)new BsonString(fieldName));
        if (unwindOptions.isPreserveNullAndEmptyArrays() != null) {
            options.append("preserveNullAndEmptyArrays", (BsonValue)BsonBoolean.valueOf((boolean)unwindOptions.isPreserveNullAndEmptyArrays()));
        }
        if (unwindOptions.getIncludeArrayIndex() != null) {
            options.append("includeArrayIndex", (BsonValue)new BsonString(unwindOptions.getIncludeArrayIndex()));
        }
        return new BsonDocument("$unwind", (BsonValue)options);
    }

    public static Bson out(String collectionName) {
        return new BsonDocument("$out", (BsonValue)new BsonString(collectionName));
    }

    public static Bson sample(int size) {
        return new BsonDocument("$sample", (BsonValue)new BsonDocument("size", (BsonValue)new BsonInt32(size)));
    }

    private Aggregates() {
    }

    private static class SimplePipelineStage
    implements Bson {
        private final String name;
        private final Bson value;

        public SimplePipelineStage(String name, Bson value) {
            this.name = name;
            this.value = value;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.name, (BsonValue)this.value.toBsonDocument(documentClass, codecRegistry));
        }
    }
}

