/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.BindException;
import java.util.List;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.responsewriter.NettyResponseWriter;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private LoggingFormatter logFormatter;
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private Proxy server;
    private ActionHandler actionHandler;

    public HttpProxyHandler(Proxy server, HttpStateHandler httpStateHandler) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
        this.logFormatter = httpStateHandler.getLogFormatter();
        this.actionHandler = new ActionHandler(httpStateHandler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block12: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(ctx);
            try {
                if (this.httpStateHandler.handle(request, (ResponseWriter)responseWriter, false)) break block12;
                if (request.matches("PUT", "/status")) {
                    responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getPorts())), "application/json");
                    break block12;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block12;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block12;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HttpProxyHandler.this.server.stop();
                        }
                    }).start();
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    ctx.channel().attr(Proxy.PROXYING).set((Object)Boolean.TRUE);
                    PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                    KeyAndCertificateFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                    ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(request.getPath().getValue(), -1)});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)request);
                } else {
                    this.actionHandler.processAction(request, (ResponseWriter)responseWriter, ctx, Proxy.getLocalAddresses(ctx), Proxy.isProxyingRequest(ctx));
                }
            }
            catch (IllegalArgumentException iae) {
                this.logFormatter.errorLog(request, (Throwable)iae, "Exception processing " + request, new Object[0]);
                responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception e) {
                this.logFormatter.errorLog(request, (Throwable)e, "Exception processing " + request, new Object[0]);
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

