/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.direct;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.direct.DirectProxyUnificationHandler;

public class DirectProxy
extends Proxy<DirectProxy> {
    private InetSocketAddress remoteSocket;

    public DirectProxy(String remoteHost, Integer remotePort, Integer ... localPorts) {
        if (remoteHost == null) {
            throw new IllegalArgumentException("You must specify a remote port");
        }
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        if (localPorts == null || localPorts.length == 0) {
            throw new IllegalArgumentException("You must specify at least one port");
        }
        this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new DirectProxyUnificationHandler()).childAttr(HTTP_PROXY, (Object)this).childAttr(ActionHandler.REMOTE_SOCKET, (Object)this.remoteSocket).childAttr(HttpStateHandler.STATE_HANDLER, (Object)new HttpStateHandler());
        this.bindToPorts(Arrays.asList(localPorts));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                DirectProxy.this.bossGroup.shutdownGracefully();
                DirectProxy.this.workerGroup.shutdownGracefully();
                try {
                    DirectProxy.this.bossGroup.terminationFuture().sync();
                    DirectProxy.this.workerGroup.terminationFuture().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }));
    }

    public int getLocalPort() {
        return this.getPort();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }
}

