/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONReflectedClass;
import org.kopitubruk.util.json.JSONReflectionException;
import org.kopitubruk.util.json.JsonObject;

public class ReflectUtil {
    private static ClassLoader classLoader = ReflectUtil.class.getClassLoader();
    public static final int PRIVATE = 0;
    public static final int PACKAGE = 1;
    public static final int PROTECTED = 2;
    public static final int PUBLIC = 3;
    private static final int MIN_PRIVACY_LEVEL = 0;
    private static final int MAX_PRIVACY_LEVEL = 3;
    private static final Pattern GETTER_PAT = Pattern.compile("^(get|is)\\p{Lu}.*$");
    private static final Class<?>[] NUMBERS = new Class[]{Number.class, Integer.TYPE, Double.TYPE, Long.TYPE, Float.TYPE, Short.TYPE, Byte.TYPE};
    static final Class<?>[] BOOLEANS = new Class[]{Boolean.class, Boolean.TYPE};
    private static final Class<?>[] STRINGS = new Class[]{CharSequence.class, Character.class, Character.TYPE};
    private static final Class<?>[] ARRAY_TYPES = new Class[]{Iterable.class, Enumeration.class};
    private static final Class<?>[] MAP_TYPES = new Class[]{Map.class, ResourceBundle.class, JsonObject.class};

    static Class<?> getClass(Object obj) {
        if (obj == null) {
            throw new JSONReflectionException();
        }
        Class<?> result = obj instanceof Class ? (Class<?>)obj : (obj instanceof JSONReflectedClass ? ((JSONReflectedClass)obj).getObjClass() : obj.getClass());
        return result;
    }

    static JSONReflectedClass ensureReflectedClass(Object obj) {
        if (obj instanceof JSONReflectedClass) {
            return (JSONReflectedClass)obj;
        }
        if (obj != null) {
            return new JSONReflectedClass(ReflectUtil.getClass(obj));
        }
        return null;
    }

    static Class<?> getClassByName(String className) throws ClassNotFoundException {
        return classLoader.loadClass(className);
    }

    static int confirmPrivacyLevel(int privacyLevel, JSONConfig cfg) throws JSONReflectionException {
        if (privacyLevel >= 0 && privacyLevel <= 3) {
            return privacyLevel;
        }
        throw new JSONReflectionException(privacyLevel, cfg);
    }

    static int getPrivacyLevel(int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            return 0;
        }
        if (Modifier.isProtected(modifiers)) {
            return 2;
        }
        if (Modifier.isPublic(modifiers)) {
            return 3;
        }
        return 1;
    }

    static Map<String, Field> getFields(Class<?> clazz, Class<?> type) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> tmpClass = clazz; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            for (Field field : tmpClass.getDeclaredFields()) {
                String name;
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || !type.equals(field.getType()) || fields.containsKey(name = field.getName())) continue;
                fields.put(name, field);
            }
        }
        return fields;
    }

    static Method getSetter(Class<?> clazz, Field field) {
        String fieldName = field.getName();
        String setterName = ReflectUtil.makeBeanMethodName(fieldName, "set");
        for (Class<?> tmpClass = clazz; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            for (Method method : tmpClass.getDeclaredMethods()) {
                if (!setterName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        }
        return null;
    }

    static String makeBeanMethodName(String fieldName, String prefix) {
        int len = fieldName.length();
        StringBuilder buf = new StringBuilder(len + prefix.length());
        buf.append(prefix);
        int codePoint = fieldName.codePointAt(0);
        int charCount = Character.charCount(codePoint);
        if (Character.isLowerCase(codePoint)) {
            codePoint = Character.toUpperCase(codePoint);
        }
        buf.appendCodePoint(codePoint);
        if (len > charCount) {
            buf.append(fieldName.substring(charCount));
        }
        return buf.toString();
    }

    static boolean isGetterName(String name, Class<?> retType) {
        if (GETTER_PAT.matcher(name).matches()) {
            if (name.startsWith("is")) {
                return ReflectUtil.isType(BOOLEANS, retType);
            }
            return true;
        }
        return false;
    }

    static boolean isSerializable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }

    static void ensureAccessible(AccessibleObject obj) {
        if (!obj.isAccessible()) {
            obj.setAccessible(true);
        }
    }

    static boolean isCompatibleInJSON(Field field, Method method) {
        Class<?>[] t2;
        Class<?>[] t1;
        Class<?> methodType;
        Class<?> fieldType = field.getType();
        if (fieldType == (methodType = method.getReturnType())) {
            return true;
        }
        Class<?>[] methodTypes = ReflectUtil.getTypes(methodType);
        if (ReflectUtil.isType(methodTypes, fieldType)) {
            return true;
        }
        Class<?>[] fieldTypes = ReflectUtil.getTypes(fieldType);
        if (fieldTypes.length < methodTypes.length) {
            t1 = fieldTypes;
            t2 = methodTypes;
        } else {
            t1 = methodTypes;
            t2 = fieldTypes;
        }
        if (ReflectUtil.isJSONNumber(t1)) {
            return ReflectUtil.isJSONNumber(t2);
        }
        if (ReflectUtil.isJSONString(t1)) {
            return ReflectUtil.isJSONString(t2);
        }
        if (ReflectUtil.isJSONBoolean(t1)) {
            return ReflectUtil.isJSONBoolean(t2);
        }
        if (ReflectUtil.isJSONArray(t1)) {
            return ReflectUtil.isJSONArray(t2);
        }
        if (ReflectUtil.isJSONMap(t1)) {
            return ReflectUtil.isJSONMap(t2);
        }
        return false;
    }

    private static boolean isJSONNumber(Class<?>[] objTypes) {
        return ReflectUtil.isType(objTypes, NUMBERS);
    }

    private static boolean isJSONBoolean(Class<?>[] objTypes) {
        return ReflectUtil.isType(objTypes, BOOLEANS);
    }

    private static boolean isJSONString(Class<?>[] objTypes) {
        return ReflectUtil.isType(objTypes, STRINGS);
    }

    private static boolean isJSONArray(Class<?>[] objTypes) {
        if (objTypes[0].isArray()) {
            return true;
        }
        return ReflectUtil.isType(objTypes, ARRAY_TYPES);
    }

    private static boolean isJSONMap(Class<?>[] objTypes) {
        return ReflectUtil.isType(objTypes, MAP_TYPES);
    }

    private static boolean isType(Class<?>[] objTypes, Class<?> type) {
        for (Class<?> objType : objTypes) {
            if (objType != type) continue;
            return true;
        }
        return false;
    }

    private static boolean isType(Class<?>[] objTypes, Class<?>[] types) {
        for (Class<?> type : types) {
            for (Class<?> objType : objTypes) {
                if (objType != type) continue;
                return true;
            }
        }
        return false;
    }

    private static Class<?>[] getTypes(Class<?> objType) {
        LinkedHashSet types = new LinkedHashSet();
        for (Class<?> tmpClass = objType; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            if ("java.lang.Object".equals(tmpClass.getCanonicalName())) continue;
            types.add(tmpClass);
        }
        ReflectUtil.getInterfaces(objType, types);
        return types.toArray(new Class[types.size()]);
    }

    private static void getInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        for (Class<?> tmpClass = clazz; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            for (Class<?> itfc : clazz.getInterfaces()) {
                if (!interfaces.add(itfc)) continue;
                ReflectUtil.getInterfaces(itfc, interfaces);
            }
        }
    }

    private ReflectUtil() {
    }
}

