/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Locale;
import java.util.ResourceBundle;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONUtil;

public class LoopDetectionFailureException
extends JSONException {
    private int stackIndex;
    private int objStackLength;
    private static final long serialVersionUID = 1L;

    LoopDetectionFailureException(int stackIndex, JSONConfig cfg) {
        super(cfg);
        this.stackIndex = stackIndex;
        this.objStackLength = cfg.getObjStack().size();
    }

    @Override
    String internalGetMessage(Locale locale) {
        ResourceBundle bundle = JSONUtil.getBundle(locale);
        if (this.stackIndex + 1 != this.objStackLength) {
            return String.format(bundle.getString("wrongStackSize"), this.objStackLength, this.stackIndex + 1);
        }
        return String.format(bundle.getString("wrongReferenceOnStack"), this.stackIndex);
    }
}

