/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Locale;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONConfigDefaults;

public abstract class JSONException
extends IllegalArgumentException {
    private Locale locale;
    private static final long serialVersionUID = 1L;

    JSONException(JSONConfig cfg) {
        this.setLocale(cfg.getLocale());
    }

    JSONException(Exception e, JSONConfig cfg) {
        super(e);
        this.setLocale(cfg.getLocale());
    }

    public void setLocale(Locale locale) {
        this.locale = locale != null ? locale : JSONConfigDefaults.getLocale();
    }

    @Override
    public String getMessage() {
        return this.internalGetMessage(JSONConfigDefaults.getLocale());
    }

    @Override
    public String getLocalizedMessage() {
        return this.internalGetMessage(this.locale);
    }

    abstract String internalGetMessage(Locale var1);

    protected String getClassName(Object obj) {
        String name = obj.getClass().getCanonicalName();
        if (name == null) {
            name = obj.getClass().isArray() ? "[array]" : "[unknown]";
        }
        return name;
    }
}

