/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.IndentPadding;
import org.kopitubruk.util.json.JSONConfigDefaults;
import org.kopitubruk.util.json.JSONConfigUtil;
import org.kopitubruk.util.json.JSONReflectedClass;
import org.kopitubruk.util.json.JSONUtil;
import org.kopitubruk.util.json.ReflectUtil;

public class JSONConfig
implements Serializable,
Cloneable {
    private static TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final int REPLACE = 0;
    public static final int DISCARD = 1;
    public static final int EXCEPTION = 2;
    public static final int ESCAPE = 3;
    public static final int PASS = 4;
    private Locale locale;
    private List<Object> objStack;
    private Pattern validationPat = null;
    private Map<Class<? extends Number>, NumberFormat> numberFormatMap = null;
    private DateFormat dateGenFormat;
    private List<DateFormat> customDateParseFormats = null;
    private List<DateFormat> dateParseFormats = null;
    private Map<Class<?>, JSONReflectedClass> reflectClasses = null;
    private IndentPadding indentPadding = null;
    private int reflectionPrivacy = 3;
    private int unmatchedSurrogatePolicy;
    private int undefinedCodePointPolicy;
    private boolean validatePropertyNames;
    private boolean detectDataStructureLoops;
    private boolean escapeBadIdentifierCodePoints;
    private boolean fullJSONIdentifierCodePoints;
    private boolean fastStrings;
    private boolean encodeNumericStringsAsNumbers;
    private boolean escapeNonAscii;
    private boolean unEscapeWherePossible;
    private boolean escapeSurrogates;
    private boolean passThroughEscapes;
    private boolean encodeDatesAsStrings;
    private boolean reflectUnknownObjects;
    private boolean preciseNumbers;
    private boolean smallNumbers;
    private boolean usePrimitiveArrays;
    private boolean cacheReflectionData;
    private boolean quoteIdentifier;
    private boolean useECMA6;
    private boolean allowReservedWordsInIdentifiers;
    private boolean encodeDatesAsObjects;
    private static final long serialVersionUID = 1L;

    public JSONConfig() {
        this(null);
    }

    public JSONConfig(Locale locale) {
        JSONConfigDefaults.initJSONConfig(this, locale);
        this.objStack = this.detectDataStructureLoops ? new ArrayList() : null;
    }

    private JSONConfig(boolean placeHolder) {
    }

    public JSONConfig clone() {
        JSONConfig result = new JSONConfig(true);
        result.objStack = this.objStack == null ? null : new ArrayList();
        result.locale = this.locale;
        if (this.numberFormatMap != null) {
            result.numberFormatMap = new HashMap<Class<? extends Number>, NumberFormat>(this.numberFormatMap.size());
            for (Map.Entry<Class<? extends Number>, NumberFormat> entry : this.numberFormatMap.entrySet()) {
                result.numberFormatMap.put(entry.getKey(), (NumberFormat)entry.getValue().clone());
            }
        } else {
            result.numberFormatMap = null;
        }
        DateFormat dateFormat = result.dateGenFormat = this.dateGenFormat == null ? null : (DateFormat)this.dateGenFormat.clone();
        if (this.customDateParseFormats != null) {
            result.customDateParseFormats = new ArrayList<DateFormat>(this.customDateParseFormats.size());
            for (DateFormat dateFormat2 : this.customDateParseFormats) {
                result.customDateParseFormats.add((DateFormat)dateFormat2.clone());
            }
        } else {
            result.customDateParseFormats = null;
        }
        if (this.reflectClasses == null) {
            result.reflectClasses = null;
        } else {
            result.reflectClasses = new HashMap(this.reflectClasses.size());
            for (Map.Entry entry : this.reflectClasses.entrySet()) {
                result.reflectClasses.put((Class<?>)entry.getKey(), ((JSONReflectedClass)entry.getValue()).clone());
            }
        }
        result.indentPadding = this.indentPadding == null ? null : this.indentPadding.clone();
        result.dateParseFormats = null;
        result.reflectionPrivacy = this.reflectionPrivacy;
        result.unmatchedSurrogatePolicy = this.unmatchedSurrogatePolicy;
        result.undefinedCodePointPolicy = this.undefinedCodePointPolicy;
        result.validatePropertyNames = this.validatePropertyNames;
        result.detectDataStructureLoops = this.detectDataStructureLoops;
        result.escapeBadIdentifierCodePoints = this.escapeBadIdentifierCodePoints;
        result.fullJSONIdentifierCodePoints = this.fullJSONIdentifierCodePoints;
        result.fastStrings = this.fastStrings;
        result.encodeNumericStringsAsNumbers = this.encodeNumericStringsAsNumbers;
        result.escapeNonAscii = this.escapeNonAscii;
        result.unEscapeWherePossible = this.unEscapeWherePossible;
        result.escapeSurrogates = this.escapeSurrogates;
        result.passThroughEscapes = this.passThroughEscapes;
        result.encodeDatesAsStrings = this.encodeDatesAsStrings;
        result.reflectUnknownObjects = this.reflectUnknownObjects;
        result.preciseNumbers = this.preciseNumbers;
        result.smallNumbers = this.smallNumbers;
        result.usePrimitiveArrays = this.usePrimitiveArrays;
        result.cacheReflectionData = this.cacheReflectionData;
        result.quoteIdentifier = this.quoteIdentifier;
        result.useECMA6 = this.useECMA6;
        result.allowReservedWordsInIdentifiers = this.allowReservedWordsInIdentifiers;
        result.encodeDatesAsObjects = this.encodeDatesAsObjects;
        return result;
    }

    List<Object> getObjStack() {
        return this.objStack;
    }

    void clearObjStack() {
        if (this.objStack != null) {
            this.objStack.clear();
        }
    }

    Pattern getPropertyNameValidationPattern() {
        if (this.validationPat == null) {
            this.validationPat = JSONUtil.getPropertyNameValidationPattern(this);
        }
        return this.validationPat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public JSONConfig setLocale(Locale locale) {
        this.locale = locale != null ? locale : JSONConfigDefaults.getLocale();
        return this;
    }

    Map<Class<? extends Number>, NumberFormat> getNumberFormats() {
        return this.numberFormatMap;
    }

    public NumberFormat getNumberFormat(Class<? extends Number> numericClass) {
        return this.numberFormatMap != null ? this.numberFormatMap.get(numericClass) : null;
    }

    public NumberFormat getNumberFormat(Number num) {
        return num != null ? this.getNumberFormat(num.getClass()) : null;
    }

    public JSONConfig addNumberFormat(Class<? extends Number> numericClass, NumberFormat fmt) {
        if (numericClass != null) {
            if (fmt == null) {
                this.removeNumberFormat(numericClass);
            } else {
                HashMap<Class<? extends Number>, NumberFormat> numFmtMap = new HashMap<Class<? extends Number>, NumberFormat>(2);
                numFmtMap.put(numericClass, fmt);
                this.addNumberFormats(numFmtMap);
            }
        }
        return this;
    }

    public JSONConfig addNumberFormat(Number numericType, NumberFormat fmt) {
        if (numericType != null) {
            this.addNumberFormat(numericType.getClass(), fmt);
        }
        return this;
    }

    public JSONConfig addNumberFormats(Map<Class<? extends Number>, NumberFormat> numFmtMap) {
        this.numberFormatMap = JSONConfigUtil.mergeFormatMaps(this.numberFormatMap, numFmtMap);
        return this;
    }

    public JSONConfig removeNumberFormat(Class<? extends Number> numericClass) {
        if (this.numberFormatMap != null && numericClass != null) {
            int size = this.numberFormatMap.size();
            this.numberFormatMap.remove(numericClass);
            if (this.numberFormatMap.size() < 1) {
                this.numberFormatMap = null;
            } else if (JSONConfigUtil.tableSizeFor(size) > JSONConfigUtil.tableSizeFor(this.numberFormatMap.size())) {
                this.numberFormatMap = new HashMap<Class<? extends Number>, NumberFormat>(this.numberFormatMap);
            }
        }
        return this;
    }

    public JSONConfig removeNumberFormat(Number num) {
        if (num != null) {
            this.removeNumberFormat(num.getClass());
        }
        return this;
    }

    public JSONConfig clearNumberFormats() {
        this.numberFormatMap = null;
        return this;
    }

    DateFormat getDateGenFormat() {
        if (this.dateGenFormat == null) {
            this.dateGenFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
            this.dateGenFormat.setTimeZone(UTC_TIME_ZONE);
        }
        return this.dateGenFormat;
    }

    public JSONConfig setDateGenFormat(DateFormat fmt) {
        this.dateGenFormat = fmt == null ? null : (DateFormat)fmt.clone();
        return this;
    }

    public DateFormat setDateGenFormat(String fmtStr) {
        SimpleDateFormat fmt = null;
        if (fmtStr != null) {
            fmt = new SimpleDateFormat(fmtStr, this.locale);
            this.setDateGenFormat(fmt);
        } else {
            this.dateGenFormat = null;
        }
        return fmt;
    }

    public JSONConfig clearDateGenFormat() {
        this.dateGenFormat = null;
        return this;
    }

    List<DateFormat> getDateParseFormats() {
        if (this.dateParseFormats == null) {
            String dateTime = "yyyy-MM-dd'T'HH:mm:ss";
            String offset = "Z";
            String millis = ".SSS";
            List<SimpleDateFormat> isoFmts = Arrays.asList(new SimpleDateFormat(dateTime + millis + offset), new SimpleDateFormat(dateTime + millis), new SimpleDateFormat(dateTime + offset), new SimpleDateFormat(dateTime));
            for (SimpleDateFormat fmt : isoFmts) {
                fmt.setTimeZone(UTC_TIME_ZONE);
            }
            if (this.customDateParseFormats == null) {
                this.dateParseFormats = new ArrayList<DateFormat>(isoFmts.size());
                this.dateParseFormats.addAll(isoFmts);
            } else {
                this.dateParseFormats = new ArrayList<DateFormat>(this.customDateParseFormats.size() + isoFmts.size());
                this.dateParseFormats.addAll(this.customDateParseFormats);
                this.dateParseFormats.addAll(isoFmts);
            }
        }
        return this.dateParseFormats;
    }

    public JSONConfig addDateParseFormat(DateFormat fmt) {
        if (fmt != null) {
            this.addDateParseFormats(Arrays.asList(fmt));
        }
        return this;
    }

    public DateFormat addDateParseFormat(String fmtStr) {
        SimpleDateFormat fmt = new SimpleDateFormat(fmtStr, this.locale);
        this.addDateParseFormat(fmt);
        return fmt;
    }

    public JSONConfig addDateParseFormats(Collection<? extends DateFormat> fmts) {
        this.customDateParseFormats = JSONConfigUtil.addDateParseFormats(this.customDateParseFormats, fmts);
        this.dateParseFormats = null;
        return this;
    }

    public JSONConfig clearDateParseFormats() {
        this.customDateParseFormats = null;
        this.dateParseFormats = null;
        return this;
    }

    public IndentPadding getIndentPadding() {
        return this.indentPadding;
    }

    public JSONConfig setIndentPadding(IndentPadding indentPadding) {
        this.indentPadding = indentPadding;
        return this;
    }

    public int getReflectionPrivacy() {
        return this.reflectionPrivacy;
    }

    public JSONConfig setReflectionPrivacy(int reflectionPrivacy) {
        this.reflectionPrivacy = ReflectUtil.confirmPrivacyLevel(reflectionPrivacy, this);
        return this;
    }

    public boolean isReflectClass(Object obj) {
        return this.getReflectedClass(obj) != null;
    }

    JSONReflectedClass ensureReflectedClass(Object obj) {
        JSONReflectedClass result = null;
        if (obj instanceof JSONReflectedClass) {
            result = (JSONReflectedClass)obj;
        } else {
            result = this.getReflectedClass(obj);
            if (result == null) {
                result = ReflectUtil.ensureReflectedClass(obj);
            }
        }
        return result;
    }

    public JSONReflectedClass getReflectedClass(Object obj) {
        return this.reflectClasses == null || obj == null ? null : this.reflectClasses.get(ReflectUtil.getClass(obj));
    }

    public JSONConfig addReflectClass(Object obj) {
        this.reflectClasses = JSONConfigUtil.addReflectClass(this.reflectClasses, obj);
        return this;
    }

    public JSONConfig addReflectClassByName(String className) throws ClassNotFoundException {
        this.addReflectClass(new JSONReflectedClass(className));
        return this;
    }

    public JSONConfig addReflectClasses(Collection<?> classes) {
        this.reflectClasses = JSONConfigUtil.addReflectClasses(this.reflectClasses, classes);
        return this;
    }

    public JSONConfig removeReflectClass(Object obj) {
        this.reflectClasses = JSONConfigUtil.removeReflectClass(this.reflectClasses, obj);
        return this;
    }

    public JSONConfig removeReflectClasses(Collection<?> classes) {
        this.reflectClasses = JSONConfigUtil.removeReflectClasses(this.reflectClasses, classes);
        return this;
    }

    public JSONConfig clearReflectClasses() {
        this.reflectClasses = null;
        return this;
    }

    void setReflectClasses(Map<Class<?>, JSONReflectedClass> refClasses) {
        this.reflectClasses = refClasses;
    }

    public int getUnmatchedSurrogatePolicy() {
        return this.unmatchedSurrogatePolicy;
    }

    public JSONConfig setUnmatchedSurrogatePolicy(int unmatchedSurrogatePolicy) {
        switch (unmatchedSurrogatePolicy) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.unmatchedSurrogatePolicy = unmatchedSurrogatePolicy;
            }
        }
        return this;
    }

    public int getUndefinedCodePointPolicy() {
        return this.undefinedCodePointPolicy;
    }

    public JSONConfig setUndefinedCodePointPolicy(int undefinedCodePointPolicy) {
        switch (undefinedCodePointPolicy) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.undefinedCodePointPolicy = undefinedCodePointPolicy;
            }
        }
        return this;
    }

    public JSONConfig setBadCharacterPolicy(int badCharacterPolicy) {
        this.setUnmatchedSurrogatePolicy(badCharacterPolicy);
        this.setUndefinedCodePointPolicy(badCharacterPolicy);
        return this;
    }

    public boolean isValidatePropertyNames() {
        return this.validatePropertyNames;
    }

    public JSONConfig setValidatePropertyNames(boolean validatePropertyNames) {
        this.validatePropertyNames = validatePropertyNames;
        return this;
    }

    public boolean isDetectDataStructureLoops() {
        return this.detectDataStructureLoops;
    }

    public JSONConfig setDetectDataStructureLoops(boolean detectDataStructureLoops) {
        this.detectDataStructureLoops = detectDataStructureLoops;
        return this;
    }

    public boolean isEscapeBadIdentifierCodePoints() {
        return this.escapeBadIdentifierCodePoints;
    }

    public JSONConfig setEscapeBadIdentifierCodePoints(boolean escapeBadIdentifierCodePoints) {
        this.escapeBadIdentifierCodePoints = escapeBadIdentifierCodePoints;
        return this;
    }

    public boolean isFullJSONIdentifierCodePoints() {
        return this.fullJSONIdentifierCodePoints;
    }

    public JSONConfig setFullJSONIdentifierCodePoints(boolean fullJSONIdentifierCodePoints) {
        this.fullJSONIdentifierCodePoints = fullJSONIdentifierCodePoints;
        if (fullJSONIdentifierCodePoints) {
            this.quoteIdentifier = true;
        }
        this.validationPat = null;
        return this;
    }

    public boolean isFastStrings() {
        return this.fastStrings;
    }

    public JSONConfig setFastStrings(boolean fastStrings) {
        this.fastStrings = fastStrings;
        return this;
    }

    public boolean isEncodeNumericStringsAsNumbers() {
        return this.encodeNumericStringsAsNumbers;
    }

    public JSONConfig setEncodeNumericStringsAsNumbers(boolean encodeNumericStringsAsNumbers) {
        this.encodeNumericStringsAsNumbers = encodeNumericStringsAsNumbers;
        return this;
    }

    public boolean isEscapeNonAscii() {
        return this.escapeNonAscii;
    }

    public JSONConfig setEscapeNonAscii(boolean escapeNonAscii) {
        this.escapeNonAscii = escapeNonAscii;
        if (escapeNonAscii) {
            this.escapeSurrogates = false;
        }
        return this;
    }

    public boolean isEscapeSurrogates() {
        return this.escapeSurrogates;
    }

    public JSONConfig setEscapeSurrogates(boolean escapeSurrogates) {
        this.escapeSurrogates = escapeSurrogates;
        if (escapeSurrogates) {
            this.escapeNonAscii = false;
        }
        return this;
    }

    public boolean isUnEscapeWherePossible() {
        return this.unEscapeWherePossible;
    }

    public JSONConfig setUnEscapeWherePossible(boolean unEscapeWherePossible) {
        this.unEscapeWherePossible = unEscapeWherePossible;
        return this;
    }

    public boolean isPassThroughEscapes() {
        return this.passThroughEscapes;
    }

    public JSONConfig setPassThroughEscapes(boolean passThroughEscapes) {
        this.passThroughEscapes = passThroughEscapes;
        return this;
    }

    public boolean isEncodeDatesAsStrings() {
        return this.encodeDatesAsStrings;
    }

    public JSONConfig setEncodeDatesAsStrings(boolean encodeDatesAsStrings) {
        this.encodeDatesAsStrings = encodeDatesAsStrings;
        if (encodeDatesAsStrings) {
            this.encodeDatesAsObjects = false;
        }
        return this;
    }

    public boolean isReflectUnknownObjects() {
        return this.reflectUnknownObjects;
    }

    public JSONConfig setReflectUnknownObjects(boolean reflectUnknownObjects) {
        this.reflectUnknownObjects = reflectUnknownObjects;
        return this;
    }

    public boolean isPreciseNumbers() {
        return this.preciseNumbers;
    }

    public JSONConfig setPreciseNumbers(boolean preciseNumbers) {
        this.preciseNumbers = preciseNumbers;
        return this;
    }

    public boolean isSmallNumbers() {
        return this.smallNumbers;
    }

    public JSONConfig setSmallNumbers(boolean smallNumbers) {
        this.smallNumbers = smallNumbers;
        return this;
    }

    public boolean isUsePrimitiveArrays() {
        return this.usePrimitiveArrays;
    }

    public JSONConfig setUsePrimitiveArrays(boolean usePrimitiveArrays) {
        this.usePrimitiveArrays = usePrimitiveArrays;
        return this;
    }

    public boolean isCacheReflectionData() {
        return this.cacheReflectionData;
    }

    public JSONConfig setCacheReflectionData(boolean cacheReflectionData) {
        this.cacheReflectionData = cacheReflectionData;
        return this;
    }

    public boolean isQuoteIdentifier() {
        return this.quoteIdentifier;
    }

    public JSONConfig setQuoteIdentifier(boolean quoteIdentifier) {
        this.quoteIdentifier = this.fullJSONIdentifierCodePoints || quoteIdentifier;
        return this;
    }

    public boolean isUseECMA6() {
        return this.useECMA6;
    }

    public JSONConfig setUseECMA6(boolean useECMA6) {
        this.useECMA6 = useECMA6;
        this.validationPat = null;
        return this;
    }

    public boolean isAllowReservedWordsInIdentifiers() {
        return this.allowReservedWordsInIdentifiers;
    }

    public JSONConfig setAllowReservedWordsInIdentifiers(boolean allowReservedWordsInIdentifiers) {
        this.allowReservedWordsInIdentifiers = allowReservedWordsInIdentifiers;
        return this;
    }

    public boolean isEncodeDatesAsObjects() {
        return this.encodeDatesAsObjects;
    }

    public JSONConfig setEncodeDatesAsObjects(boolean encodeDatesAsObjects) {
        this.encodeDatesAsObjects = encodeDatesAsObjects;
        if (encodeDatesAsObjects) {
            this.encodeDatesAsStrings = false;
        }
        return this;
    }

    public boolean isFormatDates() {
        return this.encodeDatesAsStrings || this.encodeDatesAsObjects;
    }
}

