/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.enums.ARRAY_TYPE;
import org.kie.pmml.commons.model.enums.IN_NOTIN;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.utils.ConverterTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSimpleSetPredicate
extends KiePMMLPredicate {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLSimpleSetPredicate.class);
    private final ARRAY_TYPE arrayType;
    private final IN_NOTIN inNotIn;
    protected List<Object> values;

    protected KiePMMLSimpleSetPredicate(String name, List<KiePMMLExtension> extensions, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
        super(name, extensions);
        this.arrayType = arrayType;
        this.inNotIn = inNotIn;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
        return new Builder(name, extensions, arrayType, inNotIn);
    }

    @Override
    public boolean evaluate(Map<String, Object> values) {
        boolean toReturn = false;
        if (values.containsKey(this.name)) {
            logger.debug("found matching parameter, evaluating... ");
            toReturn = this.evaluation(values.get(this.name));
        }
        return toReturn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public ARRAY_TYPE getArrayType() {
        return this.arrayType;
    }

    public IN_NOTIN getInNotIn() {
        return this.inNotIn;
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLSimpleSetPredicate.class.getSimpleName() + "[", "]").add("values=" + this.values).add("inNotIn=" + (Object)((Object)this.inNotIn)).add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLSimpleSetPredicate that = (KiePMMLSimpleSetPredicate)o;
        return Objects.equals(this.values, that.values) && this.inNotIn == that.inNotIn;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.inNotIn});
    }

    protected boolean evaluation(Object rawValue) {
        String stringValue = (String)ConverterTypeUtil.convert(String.class, rawValue);
        Object convertedValue = this.arrayType.getValue(stringValue);
        switch (this.inNotIn) {
            case IN: {
                return this.values.contains(convertedValue);
            }
            case NOT_IN: {
                return !this.values.contains(convertedValue);
            }
        }
        throw new KiePMMLException("Unknown IN_NOTIN" + (Object)((Object)this.inNotIn));
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLSimpleSetPredicate> {
        private Builder(String name, List<KiePMMLExtension> extensions, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
            super("SimpleSetPredicate-", () -> new KiePMMLSimpleSetPredicate(name, extensions, arrayType, inNotIn));
        }

        public Builder withValues(List<Object> values) {
            ((KiePMMLSimpleSetPredicate)this.toBuild).values = Collections.unmodifiableList(values);
            return this;
        }
    }
}

