/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NodeTestTaskContext;
import org.junit.platform.engine.support.hierarchical.NodeUtils;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class NodeTestTask<C extends EngineExecutionContext>
implements HierarchicalTestExecutorService.TestTask {
    private static final Logger logger = LoggerFactory.getLogger(NodeTestTask.class);
    private final NodeTestTaskContext taskContext;
    private final TestDescriptor testDescriptor;
    private final Node<C> node;
    private C parentContext;
    private C context;
    private Node.SkipResult skipResult;
    private boolean started;
    private ThrowableCollector throwableCollector;

    NodeTestTask(NodeTestTaskContext taskContext, TestDescriptor testDescriptor) {
        this.taskContext = taskContext;
        this.testDescriptor = testDescriptor;
        this.node = NodeUtils.asNode(testDescriptor);
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.taskContext.getExecutionAdvisor().getResourceLock(this.testDescriptor);
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.taskContext.getExecutionAdvisor().getForcedExecutionMode(this.testDescriptor).orElse(this.node.getExecutionMode());
    }

    void setParentContext(C parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void execute() {
        try {
            this.throwableCollector = this.taskContext.getThrowableCollectorFactory().create();
            this.prepare();
            if (this.throwableCollector.isEmpty()) {
                this.checkWhetherSkipped();
            }
            if (this.throwableCollector.isEmpty() && !this.skipResult.isSkipped()) {
                this.executeRecursively();
            }
            if (this.context != null) {
                this.cleanUp();
            }
            this.reportCompletion();
        }
        finally {
            if (Thread.interrupted()) {
                logger.debug(() -> String.format("Execution of TestDescriptor with display name [%s] and unique ID [%s] failed to clear the 'interrupted status' flag for the current thread. JUnit has cleared the flag, but you may wish to investigate why the flag was not cleared by user code.", this.testDescriptor.getDisplayName(), this.testDescriptor.getUniqueId()));
            }
        }
    }

    private void prepare() {
        this.throwableCollector.execute(() -> {
            this.context = this.node.prepare(this.parentContext);
        });
        this.parentContext = null;
    }

    private void checkWhetherSkipped() {
        this.throwableCollector.execute(() -> {
            this.skipResult = this.node.shouldBeSkipped(this.context);
        });
    }

    private void executeRecursively() {
        this.taskContext.getListener().executionStarted(this.testDescriptor);
        this.started = true;
        this.throwableCollector.execute(() -> this.node.around((EngineExecutionContext)this.context, ctx -> {
            this.context = ctx;
            this.throwableCollector.execute(() -> {
                List children = this.testDescriptor.getChildren().stream().map(descriptor -> new NodeTestTask<C>(this.taskContext, (TestDescriptor)descriptor)).collect(Collectors.toCollection(ArrayList::new));
                this.context = this.node.before(this.context);
                DefaultDynamicTestExecutor dynamicTestExecutor = new DefaultDynamicTestExecutor();
                this.context = this.node.execute(this.context, dynamicTestExecutor);
                if (!children.isEmpty()) {
                    children.forEach(child -> child.setParentContext(this.context));
                    this.taskContext.getExecutorService().invokeAll(children);
                }
                this.throwableCollector.execute(dynamicTestExecutor::awaitFinished);
            });
            this.throwableCollector.execute(() -> this.node.after(this.context));
        }));
    }

    private void cleanUp() {
        this.throwableCollector.execute(() -> this.node.cleanUp(this.context));
        this.context = null;
    }

    private void reportCompletion() {
        if (this.throwableCollector.isEmpty() && this.skipResult.isSkipped()) {
            this.taskContext.getListener().executionSkipped(this.testDescriptor, this.skipResult.getReason().orElse("<unknown>"));
            return;
        }
        if (!this.started) {
            this.taskContext.getListener().executionStarted(this.testDescriptor);
        }
        this.taskContext.getListener().executionFinished(this.testDescriptor, this.throwableCollector.toTestExecutionResult());
        this.throwableCollector = null;
    }

    private class DefaultDynamicTestExecutor
    implements Node.DynamicTestExecutor {
        private final List<Future<?>> futures = new ArrayList();

        private DefaultDynamicTestExecutor() {
        }

        @Override
        public void execute(TestDescriptor dynamicTestDescriptor) {
            NodeTestTask.this.taskContext.getListener().dynamicTestRegistered(dynamicTestDescriptor);
            Set<ExclusiveResource> exclusiveResources = NodeUtils.asNode(dynamicTestDescriptor).getExclusiveResources();
            if (!exclusiveResources.isEmpty()) {
                NodeTestTask.this.taskContext.getListener().executionStarted(dynamicTestDescriptor);
                String message = "Dynamic test descriptors must not declare exclusive resources: " + exclusiveResources;
                NodeTestTask.this.taskContext.getListener().executionFinished(dynamicTestDescriptor, TestExecutionResult.failed((Throwable)new JUnitException(message)));
            } else {
                NodeTestTask<EngineExecutionContext> nodeTestTask = new NodeTestTask<EngineExecutionContext>(NodeTestTask.this.taskContext, dynamicTestDescriptor);
                nodeTestTask.setParentContext(NodeTestTask.this.context);
                this.futures.add(NodeTestTask.this.taskContext.getExecutorService().submit(nodeTestTask));
            }
        }

        @Override
        public void awaitFinished() throws InterruptedException {
            for (Future<?> future : this.futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    ExceptionUtils.throwAsUncheckedException((Throwable)e.getCause());
                }
            }
        }
    }
}

