/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class NodeTestTask<C extends EngineExecutionContext>
implements HierarchicalTestExecutorService.TestTask {
    private final TestDescriptor testDescriptor;
    private final EngineExecutionListener listener;
    private final HierarchicalTestExecutorService executorService;
    private final ThrowableCollector.Factory throwableCollectorFactory;
    private final Node<C> node;
    private final Node.ExecutionMode executionMode;
    private final Set<ExclusiveResource> exclusiveResources;
    private final List<NodeTestTask<C>> children;
    private ResourceLock resourceLock = NopLock.INSTANCE;
    private Optional<Node.ExecutionMode> forcedExecutionMode = Optional.empty();
    private C parentContext;
    private C context;
    private Node.SkipResult skipResult;
    private boolean started;
    private ThrowableCollector throwableCollector;
    private static final Node noOpNode = new Node(){};

    NodeTestTask(TestDescriptor testDescriptor, EngineExecutionListener listener, HierarchicalTestExecutorService executorService, ThrowableCollector.Factory throwableCollectorFactory) {
        this.testDescriptor = testDescriptor;
        this.listener = listener;
        this.executorService = executorService;
        this.throwableCollectorFactory = throwableCollectorFactory;
        this.node = this.asNode(testDescriptor);
        this.executionMode = this.node.getExecutionMode();
        this.exclusiveResources = this.node.getExclusiveResources();
        this.children = testDescriptor.getChildren().stream().map(descriptor -> new NodeTestTask((TestDescriptor)descriptor, listener, executorService, throwableCollectorFactory)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Set<ExclusiveResource> getExclusiveResources() {
        return this.exclusiveResources;
    }

    public List<NodeTestTask<C>> getChildren() {
        return this.children;
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    public void setResourceLock(ResourceLock resourceLock) {
        this.resourceLock = resourceLock;
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.forcedExecutionMode.orElse(this.executionMode);
    }

    public void setForcedExecutionMode(Node.ExecutionMode forcedExecutionMode) {
        this.forcedExecutionMode = Optional.of(forcedExecutionMode);
    }

    public void setParentContext(C parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void execute() {
        this.throwableCollector = this.throwableCollectorFactory.create();
        this.prepare();
        if (this.throwableCollector.isEmpty()) {
            this.checkWhetherSkipped();
        }
        if (this.throwableCollector.isEmpty() && !this.skipResult.isSkipped()) {
            this.executeRecursively();
        }
        if (this.context != null) {
            this.cleanUp();
        }
        this.reportCompletion();
    }

    private void prepare() {
        this.throwableCollector.execute(() -> {
            this.context = this.node.prepare(this.parentContext);
        });
    }

    private void checkWhetherSkipped() {
        this.throwableCollector.execute(() -> {
            this.skipResult = this.node.shouldBeSkipped(this.context);
        });
    }

    private void executeRecursively() {
        this.listener.executionStarted(this.testDescriptor);
        this.started = true;
        this.throwableCollector.execute(() -> {
            this.context = this.node.before(this.context);
            ArrayList futures = new ArrayList();
            this.context = this.node.execute(this.context, dynamicTestDescriptor -> this.executeDynamicTest(dynamicTestDescriptor, futures));
            if (!this.children.isEmpty()) {
                this.children.forEach(child -> child.setParentContext(this.context));
                this.executorService.invokeAll(this.children);
            }
            for (Future future : futures) {
                future.get();
            }
        });
        this.throwableCollector.execute(() -> this.node.after(this.context));
    }

    private void executeDynamicTest(TestDescriptor dynamicTestDescriptor, List<Future<?>> futures) {
        this.listener.dynamicTestRegistered(dynamicTestDescriptor);
        NodeTestTask<C> nodeTestTask = new NodeTestTask<C>(dynamicTestDescriptor, this.listener, this.executorService, this.throwableCollectorFactory);
        Set<ExclusiveResource> exclusiveResources = nodeTestTask.getExclusiveResources();
        if (!exclusiveResources.isEmpty()) {
            this.listener.executionStarted(dynamicTestDescriptor);
            String message = "Dynamic test descriptors must not declare exclusive resources: " + exclusiveResources;
            this.listener.executionFinished(dynamicTestDescriptor, TestExecutionResult.failed((Throwable)new JUnitException(message)));
        } else {
            nodeTestTask.setParentContext(this.context);
            futures.add(this.executorService.submit(nodeTestTask));
        }
    }

    private void cleanUp() {
        this.throwableCollector.execute(() -> this.node.cleanUp(this.context));
    }

    private void reportCompletion() {
        if (this.throwableCollector.isEmpty() && this.skipResult.isSkipped()) {
            this.listener.executionSkipped(this.testDescriptor, this.skipResult.getReason().orElse("<unknown>"));
            return;
        }
        if (!this.started) {
            this.listener.executionStarted(this.testDescriptor);
        }
        this.listener.executionFinished(this.testDescriptor, this.throwableCollector.toTestExecutionResult());
        this.throwableCollector = null;
    }

    private Node<C> asNode(TestDescriptor testDescriptor) {
        return testDescriptor instanceof Node ? (Node)((Object)testDescriptor) : noOpNode;
    }
}

