/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutor;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.SameThreadHierarchicalTestExecutorService;

@API(status=API.Status.MAINTAINED, since="1.0")
public abstract class HierarchicalTestEngine<C extends EngineExecutionContext>
implements TestEngine {
    @Override
    public final void execute(ExecutionRequest request) {
        try (HierarchicalTestExecutorService executorService = this.createExecutorService(request);){
            new HierarchicalTestExecutor<C>(request, this.createExecutionContext(request), executorService).execute().get();
        }
        catch (Exception exception) {
            throw new JUnitException("Error executing tests for engine " + this.getId(), (Throwable)exception);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        return new SameThreadHierarchicalTestExecutorService();
    }

    protected abstract C createExecutionContext(ExecutionRequest var1);
}

