/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.junit.platform.commons.support.conversion.ConversionException;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;

class StringToCommonJavaTypesConverter
implements StringToObjectConverter {
    private static final Map<Class<?>, Function<String, ?>> CONVERTERS = Map.of(File.class, File::new, Charset.class, Charset::forName, Path.class, x$0 -> Paths.get(x$0, new String[0]), URI.class, URI::create, URL.class, StringToCommonJavaTypesConverter::toURL, Currency.class, Currency::getInstance, Locale.class, Locale::new, UUID.class, UUID::fromString);

    StringToCommonJavaTypesConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return CONVERTERS.containsKey(targetType);
    }

    @Override
    public Object convert(String source, Class<?> targetType) throws Exception {
        Function<String, ?> converter = Preconditions.notNull(CONVERTERS.get(targetType), () -> "No registered converter for %s".formatted(targetType.getName()));
        return converter.apply(source);
    }

    private static URL toURL(String url) {
        try {
            return URI.create(url).toURL();
        }
        catch (MalformedURLException ex) {
            throw new ConversionException("Failed to convert String \"" + url + "\" to type java.net.URL", ex);
        }
    }
}

