/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertAll;
import org.junit.jupiter.api.AssertArrayEquals;
import org.junit.jupiter.api.AssertDoesNotThrow;
import org.junit.jupiter.api.AssertEquals;
import org.junit.jupiter.api.AssertFalse;
import org.junit.jupiter.api.AssertInstanceOf;
import org.junit.jupiter.api.AssertIterableEquals;
import org.junit.jupiter.api.AssertLinesMatch;
import org.junit.jupiter.api.AssertNotEquals;
import org.junit.jupiter.api.AssertNotNull;
import org.junit.jupiter.api.AssertNotSame;
import org.junit.jupiter.api.AssertNull;
import org.junit.jupiter.api.AssertSame;
import org.junit.jupiter.api.AssertThrows;
import org.junit.jupiter.api.AssertThrowsExactly;
import org.junit.jupiter.api.AssertTimeout;
import org.junit.jupiter.api.AssertTimeoutPreemptively;
import org.junit.jupiter.api.AssertTrue;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.opentest4j.MultipleFailuresError;

@API(status=API.Status.STABLE, since="5.0")
public class Assertions {
    @API(status=API.Status.STABLE, since="5.3")
    protected Assertions() {
    }

    public static <V> V fail() {
        AssertionUtils.fail();
        return null;
    }

    public static <V> V fail(@Nullable String message) {
        AssertionUtils.fail(message);
        return null;
    }

    public static <V> V fail(@Nullable String message, @Nullable Throwable cause) {
        AssertionUtils.fail(message, cause);
        return null;
    }

    public static <V> V fail(@Nullable Throwable cause) {
        AssertionUtils.fail(cause);
        return null;
    }

    public static <V> V fail(Supplier<@Nullable String> messageSupplier) {
        AssertionUtils.fail(messageSupplier);
        return null;
    }

    public static void assertTrue(boolean condition) {
        AssertTrue.assertTrue(condition);
    }

    public static void assertTrue(boolean condition, Supplier<@Nullable String> messageSupplier) {
        AssertTrue.assertTrue(condition, messageSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier) {
        AssertTrue.assertTrue(booleanSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, @Nullable String message) {
        AssertTrue.assertTrue(booleanSupplier, message);
    }

    public static void assertTrue(boolean condition, @Nullable String message) {
        AssertTrue.assertTrue(condition, message);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, Supplier<@Nullable String> messageSupplier) {
        AssertTrue.assertTrue(booleanSupplier, messageSupplier);
    }

    public static void assertFalse(boolean condition) {
        AssertFalse.assertFalse(condition);
    }

    public static void assertFalse(boolean condition, @Nullable String message) {
        AssertFalse.assertFalse(condition, message);
    }

    public static void assertFalse(boolean condition, Supplier<@Nullable String> messageSupplier) {
        AssertFalse.assertFalse(condition, messageSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier) {
        AssertFalse.assertFalse(booleanSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, @Nullable String message) {
        AssertFalse.assertFalse(booleanSupplier, message);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, Supplier<@Nullable String> messageSupplier) {
        AssertFalse.assertFalse(booleanSupplier, messageSupplier);
    }

    public static void assertNull(@Nullable Object actual) {
        AssertNull.assertNull(actual);
    }

    public static void assertNull(@Nullable Object actual, @Nullable String message) {
        AssertNull.assertNull(actual, message);
    }

    public static void assertNull(@Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        AssertNull.assertNull(actual, messageSupplier);
    }

    public static void assertNotNull(@Nullable Object actual) {
        AssertNotNull.assertNotNull(actual);
    }

    public static void assertNotNull(@Nullable Object actual, @Nullable String message) {
        AssertNotNull.assertNotNull(actual, message);
    }

    public static void assertNotNull(@Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotNull.assertNotNull(actual, messageSupplier);
    }

    public static void assertEquals(short expected, short actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(short expected, @Nullable Short actual) {
        AssertEquals.assertEquals((Object)expected, actual);
    }

    public static void assertEquals(@Nullable Short expected, short actual) {
        AssertEquals.assertEquals(expected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Short expected, @Nullable Short actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(short expected, short actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(short expected, @Nullable Short actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(@Nullable Short expected, short actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Short expected, @Nullable Short actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(short expected, short actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(short expected, @Nullable Short actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Short expected, short actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Short expected, @Nullable Short actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(byte expected, byte actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(byte expected, @Nullable Byte actual) {
        AssertEquals.assertEquals((Object)expected, actual);
    }

    public static void assertEquals(@Nullable Byte expected, byte actual) {
        AssertEquals.assertEquals(expected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Byte expected, @Nullable Byte actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(byte expected, byte actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(byte expected, @Nullable Byte actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(@Nullable Byte expected, byte actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Byte expected, @Nullable Byte actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(byte expected, byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(byte expected, @Nullable Byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Byte expected, byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Byte expected, @Nullable Byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(int expected, int actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(int expected, @Nullable Integer actual) {
        AssertEquals.assertEquals((Object)expected, actual);
    }

    public static void assertEquals(@Nullable Integer expected, int actual) {
        AssertEquals.assertEquals(expected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Integer expected, @Nullable Integer actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(int expected, int actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(int expected, @Nullable Integer actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(@Nullable Integer expected, int actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Integer expected, @Nullable Integer actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(int expected, int actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(int expected, @Nullable Integer actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Integer expected, int actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Integer expected, @Nullable Integer actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(long expected, long actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(long expected, @Nullable Long actual) {
        AssertEquals.assertEquals((Object)expected, actual);
    }

    public static void assertEquals(@Nullable Long expected, long actual) {
        AssertEquals.assertEquals(expected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Long expected, @Nullable Long actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(long expected, long actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(long expected, @Nullable Long actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(@Nullable Long expected, long actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Long expected, @Nullable Long actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(long expected, long actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(long expected, @Nullable Long actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Long expected, long actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Long expected, @Nullable Long actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(float expected, float actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(float expected, @Nullable Float actual) {
        AssertEquals.assertEquals(Float.valueOf(expected), actual);
    }

    public static void assertEquals(@Nullable Float expected, float actual) {
        AssertEquals.assertEquals(expected, Float.valueOf(actual));
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Float expected, @Nullable Float actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(float expected, float actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(float expected, @Nullable Float actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)Float.valueOf(expected), (Object)actual, message);
    }

    public static void assertEquals(@Nullable Float expected, float actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)Float.valueOf(actual), message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Float expected, @Nullable Float actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(float expected, float actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(float expected, @Nullable Float actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)Float.valueOf(expected), (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Float expected, float actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)Float.valueOf(actual), messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Float expected, @Nullable Float actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        AssertEquals.assertEquals(expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, delta, message);
    }

    public static void assertEquals(float expected, float actual, float delta, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertEquals(double expected, double actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(double expected, @Nullable Double actual) {
        AssertEquals.assertEquals((Object)expected, actual);
    }

    public static void assertEquals(@Nullable Double expected, double actual) {
        AssertEquals.assertEquals(expected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Double expected, @Nullable Double actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(double expected, double actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(double expected, @Nullable Double actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(@Nullable Double expected, double actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Double expected, @Nullable Double actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(double expected, double actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(double expected, @Nullable Double actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Double expected, double actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Double expected, @Nullable Double actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        AssertEquals.assertEquals(expected, actual, delta);
    }

    public static void assertEquals(double expected, double actual, double delta, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, delta, message);
    }

    public static void assertEquals(double expected, double actual, double delta, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertEquals(char expected, char actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(char expected, @Nullable Character actual) {
        AssertEquals.assertEquals(Character.valueOf(expected), actual);
    }

    public static void assertEquals(@Nullable Character expected, char actual) {
        AssertEquals.assertEquals(expected, Character.valueOf(actual));
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Character expected, @Nullable Character actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(char expected, char actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(char expected, @Nullable Character actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)Character.valueOf(expected), (Object)actual, message);
    }

    public static void assertEquals(@Nullable Character expected, char actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)Character.valueOf(actual), message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Character expected, @Nullable Character actual, @Nullable String message) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, message);
    }

    public static void assertEquals(char expected, char actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(char expected, @Nullable Character actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)Character.valueOf(expected), (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Character expected, char actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)Character.valueOf(actual), messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertEquals(@Nullable Character expected, @Nullable Character actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(@Nullable Object expected, @Nullable Object actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(@Nullable Object expected, @Nullable Object actual, @Nullable String message) {
        AssertEquals.assertEquals(expected, actual, message);
    }

    public static void assertEquals(@Nullable Object expected, @Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta);
    }

    public static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, message);
    }

    public static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta);
    }

    public static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, message);
    }

    public static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message);
    }

    public static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertIterableEquals(@Nullable Iterable<?> expected, @Nullable Iterable<?> actual) {
        AssertIterableEquals.assertIterableEquals(expected, actual);
    }

    public static void assertIterableEquals(@Nullable Iterable<?> expected, @Nullable Iterable<?> actual, @Nullable String message) {
        AssertIterableEquals.assertIterableEquals(expected, actual, message);
    }

    public static void assertIterableEquals(@Nullable Iterable<?> expected, @Nullable Iterable<?> actual, Supplier<@Nullable String> messageSupplier) {
        AssertIterableEquals.assertIterableEquals(expected, actual, messageSupplier);
    }

    public static void assertLinesMatch(List<String> expectedLines, List<String> actualLines) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines);
    }

    public static void assertLinesMatch(List<String> expectedLines, List<String> actualLines, @Nullable String message) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, message);
    }

    public static void assertLinesMatch(List<String> expectedLines, List<String> actualLines, Supplier<@Nullable String> messageSupplier) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, messageSupplier);
    }

    public static void assertLinesMatch(Stream<String> expectedLines, Stream<String> actualLines) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines);
    }

    public static void assertLinesMatch(Stream<String> expectedLines, Stream<String> actualLines, @Nullable String message) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, message);
    }

    public static void assertLinesMatch(Stream<String> expectedLines, Stream<String> actualLines, Supplier<@Nullable String> messageSupplier) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(byte unexpected, byte actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(byte unexpected, @Nullable Byte actual) {
        AssertNotEquals.assertNotEquals((Object)unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Byte unexpected, byte actual) {
        AssertNotEquals.assertNotEquals(unexpected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Byte unexpected, @Nullable Byte actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(byte unexpected, byte actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(byte unexpected, @Nullable Byte actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Byte unexpected, byte actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Byte unexpected, @Nullable Byte actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(byte unexpected, byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(byte unexpected, @Nullable Byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Byte unexpected, byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Byte unexpected, @Nullable Byte actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(short unexpected, short actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(short unexpected, @Nullable Short actual) {
        AssertNotEquals.assertNotEquals((Object)unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Short unexpected, short actual) {
        AssertNotEquals.assertNotEquals(unexpected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Short unexpected, @Nullable Short actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(short unexpected, short actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(short unexpected, @Nullable Short actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Short unexpected, short actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Short unexpected, @Nullable Short actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(short unexpected, short actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(short unexpected, @Nullable Short actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Short unexpected, short actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Short unexpected, @Nullable Short actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(int unexpected, int actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(int unexpected, @Nullable Integer actual) {
        AssertNotEquals.assertNotEquals((Object)unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Integer unexpected, int actual) {
        AssertNotEquals.assertNotEquals(unexpected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Integer unexpected, @Nullable Integer actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(int unexpected, int actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(int unexpected, @Nullable Integer actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Integer unexpected, int actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Integer unexpected, @Nullable Integer actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(int unexpected, int actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(int unexpected, @Nullable Integer actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Integer unexpected, int actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Integer unexpected, @Nullable Integer actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(long unexpected, long actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(long unexpected, @Nullable Long actual) {
        AssertNotEquals.assertNotEquals((Object)unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Long unexpected, long actual) {
        AssertNotEquals.assertNotEquals(unexpected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Long unexpected, @Nullable Long actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(long unexpected, long actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(long unexpected, @Nullable Long actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Long unexpected, long actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Long unexpected, @Nullable Long actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(long unexpected, long actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(long unexpected, @Nullable Long actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Long unexpected, long actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Long unexpected, @Nullable Long actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, float actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, @Nullable Float actual) {
        AssertNotEquals.assertNotEquals(Float.valueOf(unexpected), actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Float unexpected, float actual) {
        AssertNotEquals.assertNotEquals(unexpected, Float.valueOf(actual));
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Float unexpected, @Nullable Float actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, float actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, @Nullable Float actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)Float.valueOf(unexpected), (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Float unexpected, float actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)Float.valueOf(actual), message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Float unexpected, @Nullable Float actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, float actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, @Nullable Float actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)Float.valueOf(unexpected), (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Float unexpected, float actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)Float.valueOf(actual), messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Float unexpected, @Nullable Float actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, float actual, float delta) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, float actual, float delta, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(float unexpected, float actual, float delta, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, double actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, @Nullable Double actual) {
        AssertNotEquals.assertNotEquals((Object)unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Double unexpected, double actual) {
        AssertNotEquals.assertNotEquals(unexpected, (Object)actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Double unexpected, @Nullable Double actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, double actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, @Nullable Double actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Double unexpected, double actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Double unexpected, @Nullable Double actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, double actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, @Nullable Double actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Double unexpected, double actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Double unexpected, @Nullable Double actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, double actual, double delta) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, double actual, double delta, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(double unexpected, double actual, double delta, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(char unexpected, char actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(char unexpected, @Nullable Character actual) {
        AssertNotEquals.assertNotEquals(Character.valueOf(unexpected), actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Character unexpected, char actual) {
        AssertNotEquals.assertNotEquals(unexpected, Character.valueOf(actual));
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Character unexpected, @Nullable Character actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(char unexpected, char actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(char unexpected, @Nullable Character actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)Character.valueOf(unexpected), (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Character unexpected, char actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)Character.valueOf(actual), message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Character unexpected, @Nullable Character actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, message);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(char unexpected, char actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(char unexpected, @Nullable Character actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)Character.valueOf(unexpected), (Object)actual, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Character unexpected, char actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)Character.valueOf(actual), messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.4")
    public static void assertNotEquals(@Nullable Character unexpected, @Nullable Character actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(@Nullable Object unexpected, @Nullable Object actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    public static void assertNotEquals(@Nullable Object unexpected, @Nullable Object actual, @Nullable String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message);
    }

    public static void assertNotEquals(@Nullable Object unexpected, @Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    public static void assertSame(@Nullable Object expected, @Nullable Object actual) {
        AssertSame.assertSame(expected, actual);
    }

    public static void assertSame(@Nullable Object expected, @Nullable Object actual, @Nullable String message) {
        AssertSame.assertSame(expected, actual, message);
    }

    public static void assertSame(@Nullable Object expected, @Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        AssertSame.assertSame(expected, actual, messageSupplier);
    }

    public static void assertNotSame(@Nullable Object unexpected, @Nullable Object actual) {
        AssertNotSame.assertNotSame(unexpected, actual);
    }

    public static void assertNotSame(@Nullable Object unexpected, @Nullable Object actual, @Nullable String message) {
        AssertNotSame.assertNotSame(unexpected, actual, message);
    }

    public static void assertNotSame(@Nullable Object unexpected, @Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        AssertNotSame.assertNotSame(unexpected, actual, messageSupplier);
    }

    public static void assertAll(Executable ... executables) throws MultipleFailuresError {
        AssertAll.assertAll(executables);
    }

    public static void assertAll(@Nullable String heading, Executable ... executables) throws MultipleFailuresError {
        AssertAll.assertAll(heading, executables);
    }

    public static void assertAll(Collection<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(executables);
    }

    public static void assertAll(@Nullable String heading, Collection<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(heading, executables);
    }

    public static void assertAll(Stream<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(executables);
    }

    public static void assertAll(@Nullable String heading, Stream<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(heading, executables);
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable);
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, @Nullable String message) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, message);
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, Supplier<@Nullable String> messageSupplier) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, messageSupplier);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable) {
        return AssertThrows.assertThrows(expectedType, executable);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, @Nullable String message) {
        return AssertThrows.assertThrows(expectedType, executable, message);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, Supplier<@Nullable String> messageSupplier) {
        return AssertThrows.assertThrows(expectedType, executable, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.2")
    public static void assertDoesNotThrow(Executable executable) {
        AssertDoesNotThrow.assertDoesNotThrow(executable);
    }

    @API(status=API.Status.STABLE, since="5.2")
    public static void assertDoesNotThrow(Executable executable, @Nullable String message) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, message);
    }

    @API(status=API.Status.STABLE, since="5.2")
    public static void assertDoesNotThrow(Executable executable, Supplier<@Nullable String> messageSupplier) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, messageSupplier);
    }

    @API(status=API.Status.STABLE, since="5.2")
    public static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier);
    }

    @API(status=API.Status.STABLE, since="5.2")
    public static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, @Nullable String message) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, message);
    }

    @API(status=API.Status.STABLE, since="5.2")
    public static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, messageSupplier);
    }

    public static void assertTimeout(Duration timeout, Executable executable) {
        AssertTimeout.assertTimeout(timeout, executable);
    }

    public static void assertTimeout(Duration timeout, Executable executable, @Nullable String message) {
        AssertTimeout.assertTimeout(timeout, executable, message);
    }

    public static void assertTimeout(Duration timeout, Executable executable, Supplier<@Nullable String> messageSupplier) {
        AssertTimeout.assertTimeout(timeout, executable, messageSupplier);
    }

    public static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeout(timeout, supplier);
    }

    public static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, @Nullable String message) {
        return AssertTimeout.assertTimeout(timeout, supplier, message);
    }

    public static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier) {
        return AssertTimeout.assertTimeout(timeout, supplier, messageSupplier);
    }

    public static void assertTimeoutPreemptively(Duration timeout, Executable executable) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, executable);
    }

    public static void assertTimeoutPreemptively(Duration timeout, Executable executable, @Nullable String message) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, executable, message);
    }

    public static void assertTimeoutPreemptively(Duration timeout, Executable executable, Supplier<@Nullable String> messageSupplier) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, executable, messageSupplier);
    }

    public static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier) {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier);
    }

    public static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, @Nullable String message) {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier, message);
    }

    public static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier) {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier, messageSupplier);
    }

    @API(status=API.Status.INTERNAL, since="5.9.1")
    public static <T, E extends Throwable> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier, TimeoutFailureFactory<E> failureFactory) throws E {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier, messageSupplier, failureFactory);
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue);
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, @Nullable String message) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, message);
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, Supplier<@Nullable String> messageSupplier) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, messageSupplier);
    }

    @API(status=API.Status.INTERNAL, since="5.9.1")
    public static interface TimeoutFailureFactory<T extends Throwable> {
        public T createTimeoutFailure(Duration var1, @Nullable Supplier<@Nullable String> var2, @Nullable Throwable var3, @Nullable Thread var4);
    }
}

