/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;

public class PathUtil {
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final String JS_LIB_JAR_NAME = "kotlin-stdlib-js.jar";
    public static final String JS_LIB_10_JAR_NAME = "kotlin-jslib.jar";
    public static final String ALLOPEN_PLUGIN_JAR_NAME = "allopen-compiler-plugin.jar";
    public static final String NOARG_PLUGIN_JAR_NAME = "noarg-compiler-plugin.jar";
    public static final String SAM_WITH_RECEIVER_PLUGIN_JAR_NAME = "sam-with-receiver-compiler-plugin.jar";
    public static final String JS_LIB_SRC_JAR_NAME = "kotlin-stdlib-js-sources.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JAR = "kotlin-runtime.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE7_JAR = "kotlin-stdlib-jre7.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE8_JAR = "kotlin-stdlib-jre8.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE7_SRC_JAR = "kotlin-stdlib-jre7-sources.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE8_SRC_JAR = "kotlin-stdlib-jre8-sources.jar";
    public static final String KOTLIN_JAVA_STDLIB_JAR = "kotlin-stdlib.jar";
    public static final String KOTLIN_JAVA_REFLECT_JAR = "kotlin-reflect.jar";
    public static final String KOTLIN_JAVA_SCRIPT_RUNTIME_JAR = "kotlin-script-runtime.jar";
    public static final String KOTLIN_TEST_JAR = "kotlin-test.jar";
    public static final String KOTLIN_TEST_JS_JAR = "kotlin-test-js.jar";
    public static final String KOTLIN_JAVA_STDLIB_SRC_JAR = "kotlin-stdlib-sources.jar";
    public static final String KOTLIN_JAVA_STDLIB_SRC_JAR_OLD = "kotlin-runtime-sources.jar";
    public static final String KOTLIN_REFLECT_SRC_JAR = "kotlin-reflect-sources.jar";
    public static final String KOTLIN_TEST_SRC_JAR = "kotlin-test-sources.jar";
    public static final String KOTLIN_COMPILER_JAR = "kotlin-compiler.jar";
    public static final Pattern KOTLIN_RUNTIME_JAR_PATTERN = Pattern.compile("kotlin-(stdlib|runtime)(-\\d[\\d.]+(-.+)?)?\\.jar");
    public static final Pattern KOTLIN_STDLIB_JS_JAR_PATTERN = Pattern.compile("kotlin-stdlib-js.*\\.jar");
    public static final Pattern KOTLIN_JS_LIBRARY_JAR_PATTERN = Pattern.compile("kotlin-js-library.*\\.jar");
    public static final String HOME_FOLDER_NAME = "kotlinc";
    private static final File NO_PATH = new File("<no_path>");

    private PathUtil() {
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForIdeaPlugin() {
        KotlinPaths kotlinPaths = ApplicationManager.getApplication().isUnitTestMode() ? PathUtil.getKotlinPathsForDistDirectory() : new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForIdeaPlugin());
        if (kotlinPaths == null) {
            PathUtil.$$$reportNull$$$0(0);
        }
        return kotlinPaths;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPlugin() {
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
            if (kotlinPathsFromHomeDir == null) {
                PathUtil.$$$reportNull$$$0(1);
            }
            return kotlinPathsFromHomeDir;
        }
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForJpsPlugin());
        if (kotlinPathsFromHomeDir == null) {
            PathUtil.$$$reportNull$$$0(2);
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPluginOrJpsTests() {
        if ("true".equalsIgnoreCase(System.getProperty("kotlin.jps.tests"))) {
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
            if (kotlinPaths == null) {
                PathUtil.$$$reportNull$$$0(3);
            }
            return kotlinPaths;
        }
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForJpsPlugin();
        if (kotlinPaths == null) {
            PathUtil.$$$reportNull$$$0(4);
        }
        return kotlinPaths;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForCompiler() {
        if (!PathUtil.getPathUtilJar().isFile()) {
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
            if (kotlinPaths == null) {
                PathUtil.$$$reportNull$$$0(5);
            }
            return kotlinPaths;
        }
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForCompilerJar());
        if (kotlinPathsFromHomeDir == null) {
            PathUtil.$$$reportNull$$$0(6);
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForDistDirectory() {
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(new File("dist", HOME_FOLDER_NAME));
        if (kotlinPathsFromHomeDir == null) {
            PathUtil.$$$reportNull$$$0(7);
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    private static File getCompilerPathForCompilerJar() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                PathUtil.$$$reportNull$$$0(8);
            }
            return file;
        }
        if (jar.getName().equals(KOTLIN_COMPILER_JAR)) {
            File lib = jar.getParentFile();
            File file = lib.getParentFile();
            if (file == null) {
                PathUtil.$$$reportNull$$$0(9);
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            PathUtil.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    private static File getCompilerPathForJpsPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                PathUtil.$$$reportNull$$$0(11);
            }
            return file;
        }
        if (jar.getName().equals("kotlin-jps-plugin.jar")) {
            File pluginHome = jar.getParentFile().getParentFile().getParentFile();
            File file = new File(pluginHome, HOME_FOLDER_NAME);
            if (file == null) {
                PathUtil.$$$reportNull$$$0(12);
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            PathUtil.$$$reportNull$$$0(13);
        }
        return file;
    }

    @NotNull
    private static File getCompilerPathForIdeaPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                PathUtil.$$$reportNull$$$0(14);
            }
            return file;
        }
        if (jar.getName().equals("kotlin-plugin.jar")) {
            File lib = jar.getParentFile();
            File pluginHome = lib.getParentFile();
            File file = new File(pluginHome, HOME_FOLDER_NAME);
            if (file == null) {
                PathUtil.$$$reportNull$$$0(15);
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            PathUtil.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public static File getPathUtilJar() {
        File file = PathUtil.getResourcePathForClass(PathUtil.class);
        if (file == null) {
            PathUtil.$$$reportNull$$$0(17);
        }
        return file;
    }

    @NotNull
    public static File getResourcePathForClass(@NotNull Class aClass2) {
        String path;
        String resourceRoot;
        if (aClass2 == null) {
            PathUtil.$$$reportNull$$$0(18);
        }
        if ((resourceRoot = PathManager.getResourceRoot(aClass2, path = "/" + aClass2.getName().replace('.', '/') + ".class")) == null) {
            throw new IllegalStateException("Resource not found: " + path);
        }
        File file = new File(resourceRoot).getAbsoluteFile();
        if (file == null) {
            PathUtil.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    public static List<File> getJdkClassesRootsFromCurrentJre() {
        List<File> list2 = PathUtil.getJdkClassesRootsFromJre(System.getProperty("java.home"));
        if (list2 == null) {
            PathUtil.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public static List<File> getJdkClassesRootsFromJre(@NotNull String javaHome) {
        if (javaHome == null) {
            PathUtil.$$$reportNull$$$0(21);
        }
        List<File> list2 = JavaSdkUtil.getJdkClassesRoots(new File(javaHome), true);
        if (list2 == null) {
            PathUtil.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File jdkHome) {
        if (jdkHome == null) {
            PathUtil.$$$reportNull$$$0(23);
        }
        List<File> list2 = JavaSdkUtil.getJdkClassesRoots(jdkHome, false);
        if (list2 == null) {
            PathUtil.$$$reportNull$$$0(24);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/utils/PathUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaHome";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPathsForIdeaPlugin";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPathsForJpsPlugin";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPathsForJpsPluginOrJpsTests";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPathsForCompiler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPathsForDistDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerPathForCompilerJar";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerPathForJpsPlugin";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerPathForIdeaPlugin";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathUtilJar";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/utils/PathUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePathForClass";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRootsFromCurrentJre";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRootsFromJre";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePathForClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRootsFromJre";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

