/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer.common;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.analyzer.AnalyzerFacade;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PlatformAnalysisParameters;
import org.jetbrains.kotlin.analyzer.ResolverForModule;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.analyzer.common.DefaultAnalyzerFacade;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.TargetPlatformVersion;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.ContainerKt;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackagePartProvider;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.MetadataFinderFactory;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatformKt;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragmentProvider;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003JZ\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0018J8\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001bH\u0002J]\u0010)\u001a\u00020*\"\b\b\u0000\u0010+*\u00020\u00192\u0006\u0010,\u001a\u0002H+2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H+022\u0006\u0010(\u001a\u00020\u001bH\u0014\u00a2\u0006\u0002\u00103R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/analyzer/common/DefaultAnalyzerFacade;", "Lorg/jetbrains/kotlin/analyzer/AnalyzerFacade;", "Lorg/jetbrains/kotlin/analyzer/PlatformAnalysisParameters;", "()V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "analyzeFiles", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleName", "Lorg/jetbrains/kotlin/name/Name;", "dependOnBuiltIns", "", "capabilities", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "", "packagePartProviderFactory", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/ModuleContent;", "Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;", "createContainerToResolveCommonCode", "Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "declarationProviderFactory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProviderFactory;", "moduleContentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "targetEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "packagePartProvider", "createResolverForModule", "Lorg/jetbrains/kotlin/analyzer/ResolverForModule;", "M", "moduleInfo", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "moduleContent", "platformParameters", "resolverForProject", "Lorg/jetbrains/kotlin/analyzer/ResolverForProject;", "(Lorg/jetbrains/kotlin/analyzer/ModuleInfo;Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;Lorg/jetbrains/kotlin/context/ModuleContext;Lorg/jetbrains/kotlin/analyzer/ModuleContent;Lorg/jetbrains/kotlin/analyzer/PlatformAnalysisParameters;Lorg/jetbrains/kotlin/resolve/TargetEnvironment;Lorg/jetbrains/kotlin/analyzer/ResolverForProject;Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;)Lorg/jetbrains/kotlin/analyzer/ResolverForModule;", "SourceModuleInfo", "kotlin-compiler"})
public final class DefaultAnalyzerFacade
extends AnalyzerFacade<PlatformAnalysisParameters> {
    private static final LanguageVersionSettingsImpl languageVersionSettings;
    public static final DefaultAnalyzerFacade INSTANCE;

    @NotNull
    public final AnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Name moduleName, boolean dependOnBuiltIns, @NotNull Map<ModuleDescriptor.Capability<?>, ? extends Object> capabilities, @NotNull Function2<? super ModuleInfo, ? super ModuleContent, ? extends PackagePartProvider> packagePartProviderFactory) {
        ComponentProvider container2;
        UserDataHolder project;
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(capabilities, "capabilities");
        Intrinsics.checkParameterIsNotNull(packagePartProviderFactory, "packagePartProviderFactory");
        SourceModuleInfo moduleInfo = new SourceModuleInfo(moduleName, capabilities, dependOnBuiltIns);
        UserDataHolder userDataHolder = (KtFile)CollectionsKt.firstOrNull((Iterable)files2);
        if (userDataHolder == null || (userDataHolder = userDataHolder.getProject()) == null) {
            throw (Throwable)((Object)new AssertionError((Object)"No files to analyze"));
        }
        UserDataHolder userDataHolder2 = project = userDataHolder;
        Intrinsics.checkExpressionValueIsNotNull(userDataHolder2, "project");
        ResolverForProject resolver2 = AnalyzerFacade.Companion.setupResolverForProject$default(AnalyzerFacade.Companion, "sources for metadata serializer", ContextKt.ProjectContext((Project)userDataHolder2), CollectionsKt.listOf(moduleInfo), analyzeFiles.resolver.1.INSTANCE, new Function1<SourceModuleInfo, ModuleContent>(files2, (Project)project){
            final /* synthetic */ Collection $files;
            final /* synthetic */ Project $project;

            @NotNull
            public final ModuleContent invoke(@NotNull SourceModuleInfo it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.$project);
                Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.allScope(project)");
                return new ModuleContent(this.$files, globalSearchScope);
            }
            {
                this.$files = collection;
                this.$project = project;
                super(1);
            }
        }, new PlatformAnalysisParameters(){}, null, null, null, packagePartProviderFactory, null, analyzeFiles.resolver.4.INSTANCE, null, 5568, null);
        ModuleDescriptor moduleDescriptor = resolver2.descriptorForModule((ModuleInfo)moduleInfo);
        ComponentProvider $receiver$iv = container2 = resolver2.resolverForModule((ModuleInfo)moduleInfo).getComponentProvider();
        LazyTopDownAnalyzer.analyzeDeclarations$default(DslKt.getService($receiver$iv, LazyTopDownAnalyzer.class), TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        $receiver$iv = container2;
        AnalysisResult.Companion companion = AnalysisResult.Companion;
        BindingTrace bindingTrace = DslKt.getService($receiver$iv, BindingTrace.class);
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "container.get<BindingTrace>().bindingContext");
        return companion.success(bindingContext, moduleDescriptor);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AnalysisResult analyzeFiles$default(DefaultAnalyzerFacade defaultAnalyzerFacade, Collection collection, Name name, boolean bl, Map map2, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = MapsKt.mapOf(TuplesKt.to(MultiTargetPlatform.CAPABILITY, MultiTargetPlatform.Common.INSTANCE));
        }
        return defaultAnalyzerFacade.analyzeFiles(collection, name, bl, map2, function2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected <M extends ModuleInfo> ResolverForModule createResolverForModule(@NotNull M moduleInfo, @NotNull ModuleDescriptorImpl moduleDescriptor, @NotNull ModuleContext moduleContext, @NotNull ModuleContent moduleContent, @NotNull PlatformAnalysisParameters platformParameters, @NotNull TargetEnvironment targetEnvironment, @NotNull ResolverForProject<M> resolverForProject2, @NotNull PackagePartProvider packagePartProvider) {
        ComponentProvider $receiver$iv;
        PackageFragmentProvider[] packageFragmentProviderArray;
        void syntheticFiles;
        void moduleContentScope;
        Intrinsics.checkParameterIsNotNull(moduleInfo, "moduleInfo");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(moduleContext, "moduleContext");
        Intrinsics.checkParameterIsNotNull(moduleContent, "moduleContent");
        Intrinsics.checkParameterIsNotNull(platformParameters, "platformParameters");
        Intrinsics.checkParameterIsNotNull(targetEnvironment, "targetEnvironment");
        Intrinsics.checkParameterIsNotNull(resolverForProject2, "resolverForProject");
        Intrinsics.checkParameterIsNotNull(packagePartProvider, "packagePartProvider");
        ModuleContent moduleContent2 = moduleContent;
        Collection<KtFile> collection = moduleContent2.component1();
        GlobalSearchScope globalSearchScope = moduleContent2.component2();
        moduleContent2 = null;
        Project project = moduleContext.getProject();
        StorageManager storageManager = moduleContext.getStorageManager();
        Object object = moduleInfo.isLibrary() ? GlobalSearchScope.EMPTY_SCOPE : moduleContentScope;
        Intrinsics.checkExpressionValueIsNotNull(object, "if (moduleInfo.isLibrary\u2026E else moduleContentScope");
        DeclarationProviderFactory declarationProviderFactory2 = DeclarationProviderFactoryService.Companion.createDeclarationProviderFactory(project, storageManager, (Collection<? extends KtFile>)syntheticFiles, (GlobalSearchScope)object, moduleInfo);
        BindingTrace trace = CodeAnalyzerInitializer.Companion.getInstance(project).createTrace();
        StorageComponentContainer container2 = this.createContainerToResolveCommonCode(moduleContext, trace, declarationProviderFactory2, (GlobalSearchScope)moduleContentScope, targetEnvironment, packagePartProvider);
        ComponentProvider componentProvider = container2;
        int n = 0;
        PackageFragmentProvider[] packageFragmentProviderArray2 = packageFragmentProviderArray = new PackageFragmentProvider[2];
        Object object2 = DslKt.getService($receiver$iv, ResolveSession.class);
        packageFragmentProviderArray[n] = ((ResolveSession)object2).getPackageFragmentProvider();
        $receiver$iv = container2;
        n = 1;
        packageFragmentProviderArray = packageFragmentProviderArray2;
        object2 = DslKt.getService($receiver$iv, MetadataPackageFragmentProvider.class);
        packageFragmentProviderArray[n] = (PackageFragmentProvider)object2;
        List<PackageFragmentProvider[]> packageFragmentProviders = CollectionsKt.listOf(packageFragmentProviderArray2);
        return new ResolverForModule(new CompositePackageFragmentProvider(packageFragmentProviders), container2);
    }

    private final StorageComponentContainer createContainerToResolveCommonCode(ModuleContext moduleContext, BindingTrace bindingTrace, DeclarationProviderFactory declarationProviderFactory2, GlobalSearchScope moduleContentScope, TargetEnvironment targetEnvironment, PackagePartProvider packagePartProvider) {
        return TargetPlatformKt.createContainer("ResolveCommonCode", this.getTargetPlatform(), (Function1<? super StorageComponentContainer, Unit>)new Function1<StorageComponentContainer, Unit>(moduleContext, bindingTrace, moduleContentScope, packagePartProvider, declarationProviderFactory2, targetEnvironment){
            final /* synthetic */ ModuleContext $moduleContext;
            final /* synthetic */ BindingTrace $bindingTrace;
            final /* synthetic */ GlobalSearchScope $moduleContentScope;
            final /* synthetic */ PackagePartProvider $packagePartProvider;
            final /* synthetic */ DeclarationProviderFactory $declarationProviderFactory;
            final /* synthetic */ TargetEnvironment $targetEnvironment;

            public final void invoke(@NotNull StorageComponentContainer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                InjectionKt.configureModule($receiver, this.$moduleContext, DefaultAnalyzerFacade.INSTANCE.getTargetPlatform(), TargetPlatformVersion.NoVersion.INSTANCE, this.$bindingTrace);
                DslKt.useInstance($receiver, this.$moduleContentScope);
                DslKt.useInstance($receiver, LookupTracker.DO_NOTHING.INSTANCE);
                StorageComponentContainer $receiver$iv = $receiver;
                ContainerKt.registerSingleton($receiver$iv, ResolveSession.class);
                $receiver$iv = $receiver;
                ContainerKt.registerSingleton($receiver$iv, LazyTopDownAnalyzer.class);
                DslKt.useInstance($receiver, DefaultAnalyzerFacade.access$getLanguageVersionSettings$p(DefaultAnalyzerFacade.INSTANCE));
                $receiver$iv = $receiver;
                ContainerKt.registerSingleton($receiver$iv, AnnotationResolverImpl.class);
                $receiver$iv = $receiver;
                ContainerKt.registerSingleton($receiver$iv, CompilerDeserializationConfiguration.class);
                DslKt.useInstance($receiver, this.$packagePartProvider);
                DslKt.useInstance($receiver, this.$declarationProviderFactory);
                $receiver$iv = $receiver;
                ContainerKt.registerSingleton($receiver$iv, MetadataPackageFragmentProvider.class);
                MetadataFinderFactory metadataFinderFactory = ServiceManager.getService(this.$moduleContext.getProject(), MetadataFinderFactory.class);
                if (metadataFinderFactory == null) {
                    String string = "No MetadataFinderFactory in project";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                MetadataFinderFactory metadataFinderFactory2 = metadataFinderFactory;
                DslKt.useInstance($receiver, metadataFinderFactory2.create(this.$moduleContentScope));
                this.$targetEnvironment.configure($receiver);
            }
            {
                this.$moduleContext = moduleContext;
                this.$bindingTrace = bindingTrace;
                this.$moduleContentScope = globalSearchScope;
                this.$packagePartProvider = packagePartProvider;
                this.$declarationProviderFactory = declarationProviderFactory2;
                this.$targetEnvironment = targetEnvironment;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return TargetPlatform.Default.INSTANCE;
    }

    private DefaultAnalyzerFacade() {
        INSTANCE = this;
        languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, MapsKt.mapOf(TuplesKt.to(LanguageFeature.MultiPlatformProjects, LanguageFeature.State.ENABLED)), 4, null);
    }

    static {
        new DefaultAnalyzerFacade();
    }

    @NotNull
    public static final /* synthetic */ LanguageVersionSettingsImpl access$getLanguageVersionSettings$p(DefaultAnalyzerFacade $this) {
        DefaultAnalyzerFacade defaultAnalyzerFacade = $this;
        return languageVersionSettings;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R&\u0010\u0004\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analyzer/common/DefaultAnalyzerFacade$SourceModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "name", "Lorg/jetbrains/kotlin/name/Name;", "capabilities", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "", "dependOnOldBuiltIns", "", "(Lorg/jetbrains/kotlin/name/Name;Ljava/util/Map;Z)V", "getCapabilities", "()Ljava/util/Map;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "dependencies", "", "dependencyOnBuiltIns", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo$DependencyOnBuiltIns;", "kotlin-compiler"})
    private static final class SourceModuleInfo
    implements ModuleInfo {
        @NotNull
        private final Name name;
        @NotNull
        private final Map<ModuleDescriptor.Capability<?>, Object> capabilities;
        private final boolean dependOnOldBuiltIns;

        @NotNull
        public List<SourceModuleInfo> dependencies() {
            return CollectionsKt.listOf(this);
        }

        @Override
        @NotNull
        public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
            return this.dependOnOldBuiltIns ? ModuleInfo.DependencyOnBuiltIns.LAST : ModuleInfo.DependencyOnBuiltIns.NONE;
        }

        @Override
        @NotNull
        public Name getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
            return this.capabilities;
        }

        public SourceModuleInfo(@NotNull Name name, @NotNull Map<ModuleDescriptor.Capability<?>, ? extends Object> capabilities, boolean dependOnOldBuiltIns) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(capabilities, "capabilities");
            this.name = name;
            this.capabilities = capabilities;
            this.dependOnOldBuiltIns = dependOnOldBuiltIns;
        }

        @Override
        public boolean isLibrary() {
            return ModuleInfo.DefaultImpls.isLibrary(this);
        }

        @Override
        @NotNull
        public String getDisplayedName() {
            return ModuleInfo.DefaultImpls.getDisplayedName(this);
        }

        @Override
        @Nullable
        public TargetPlatform getPlatform() {
            return ModuleInfo.DefaultImpls.getPlatform(this);
        }

        @Override
        @NotNull
        public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
            return ModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
        }
    }
}

