/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.view;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.poi.excel.view.BigExcelExportView;
import org.jeecgframework.poi.excel.view.JeecgMapExcelView;
import org.jeecgframework.poi.excel.view.JeecgSingleExcelView;
import org.jeecgframework.poi.excel.view.JeecgTemplateExcelView;
import org.jeecgframework.poi.excel.view.MapGraphExcelView;
import org.jeecgframework.poi.excel.view.MiniAbstractExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;

public abstract class PoiBaseView
extends AbstractView {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiBaseView.class);

    protected static boolean isIE(HttpServletRequest request) {
        return request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("rv:11.0") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("edge") > 0;
    }

    public static void render(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response, String viewName) {
        MiniAbstractExcelView view = null;
        if ("bigExcelView".equals(viewName)) {
            view = new BigExcelExportView();
        } else if ("jeecgMapExcelView".equals(viewName)) {
            view = new JeecgMapExcelView();
        } else if ("jeecgExcelView".equals(viewName)) {
            view = new JeecgSingleExcelView();
        } else if ("jeecgTemplateExcelView".equals(viewName)) {
            view = new JeecgTemplateExcelView();
        } else if ("MapGraphExcelView".equals(viewName)) {
            view = new MapGraphExcelView();
        }
        try {
            view.renderMergedOutputModel(model, request, response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

