/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.pdf.styler;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import java.io.IOException;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.pdf.styler.IPdfExportStyler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExportStylerDefaultImpl
implements IPdfExportStyler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfExportStylerDefaultImpl.class);

    @Override
    public Document getDocument() {
        return new Document(PageSize.A4, 36.0f, 36.0f, 24.0f, 36.0f);
    }

    @Override
    public void setCellStyler(PdfPCell iCell, ExcelExportEntity entity, String text) {
        iCell.setHorizontalAlignment(1);
        iCell.setVerticalAlignment(5);
    }

    @Override
    public Font getFont(ExcelExportEntity entity, String text) {
        try {
            BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font font = new Font(bfChinese);
            return font;
        }
        catch (DocumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        Font font = new Font(Font.FontFamily.UNDEFINED);
        return font;
    }
}

