/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.cache.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jeecgframework.poi.cache.manager.FileLoadeImpl;
import org.jeecgframework.poi.cache.manager.IFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POICacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(POICacheManager.class);
    private static LoadingCache<String, byte[]> loadingCache;
    private static IFileLoader fileLoder;
    private static ThreadLocal<IFileLoader> LOCAL_FILELOADER;

    public static InputStream getFile(String id) {
        try {
            byte[] result = Arrays.copyOf((byte[])loadingCache.get((Object)id), ((byte[])loadingCache.get((Object)id)).length);
            return new ByteArrayInputStream(result);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void setFileLoder(IFileLoader fileLoder) {
        POICacheManager.fileLoder = fileLoder;
    }

    public static void setFileLoderOnce(IFileLoader fileLoder) {
        if (fileLoder != null) {
            LOCAL_FILELOADER.set(fileLoder);
        }
    }

    public static void setLoadingCache(LoadingCache<String, byte[]> loadingCache) {
        POICacheManager.loadingCache = loadingCache;
    }

    static {
        LOCAL_FILELOADER = new ThreadLocal();
        loadingCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(50L).build((CacheLoader)new CacheLoader<String, byte[]>(){

            public byte[] load(String url) throws Exception {
                if (LOCAL_FILELOADER.get() != null) {
                    return ((IFileLoader)LOCAL_FILELOADER.get()).getFile(url);
                }
                return fileLoder.getFile(url);
            }
        });
        fileLoder = new FileLoadeImpl();
    }
}

