/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.jeecgframework.poi.excel.entity.ExcelToHtmlParams;
import org.jeecgframework.poi.excel.html.ExcelToHtmlServer;

public class HtmlCache {
    private static LoadingCache<ExcelToHtmlParams, String> loadingCache = CacheBuilder.newBuilder().expireAfterWrite(7L, TimeUnit.DAYS).maximumSize(200L).build((CacheLoader)new CacheLoader<ExcelToHtmlParams, String>(){

        public String load(ExcelToHtmlParams params) throws Exception {
            return new ExcelToHtmlServer(params).printPage();
        }
    });

    public static String getHtml(ExcelToHtmlParams params) {
        try {
            return (String)loadingCache.get((Object)params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

