/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.util.Preconditions;

public class BeanArchiveBuilder {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Set<String> classes = new HashSet<String>();
    private BeansXml beansXml;
    private String id;

    public WeldBeanDeploymentArchive build() {
        Preconditions.checkArgumentNotNull(this.id, "id");
        return new WeldBeanDeploymentArchive(this.id, this.classes, this.getBeansXml());
    }

    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public BeanArchiveBuilder setBeansXml(BeansXml beansXml) {
        this.beansXml = beansXml;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public BeanArchiveBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public BeanArchiveBuilder addClass(String className) {
        this.classes.add(className);
        return this;
    }

    public BeanArchiveBuilder clearClasses() {
        this.classes.clear();
        return this;
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public BeanArchiveBuilder setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Iterator<String> getClassIterator() {
        return this.classes.iterator();
    }
}

