/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.util.HeaderParameterParser;

public class MediaTypeHeaderDelegate
implements RuntimeDelegate.HeaderDelegate {
    private static final char[] quotedChars = "()<>@,;:\\\"/[]?= \t\r\n".toCharArray();

    public Object fromString(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("MediaType value is null");
        }
        return MediaTypeHeaderDelegate.parse(type);
    }

    public static MediaType parse(String type) {
        int typeIndex = type.indexOf(47);
        int paramIndex = type.indexOf(59);
        String major = null;
        String subtype = null;
        if (typeIndex < 0) {
            major = type;
            if (paramIndex > -1) {
                major = major.substring(0, paramIndex);
            }
            if (!"*".equals(major)) {
                throw new IllegalArgumentException("Failure parsing MediaType string: " + type);
            }
            subtype = "*";
        } else {
            major = type.substring(0, typeIndex);
            subtype = paramIndex > -1 ? type.substring(typeIndex + 1, paramIndex) : type.substring(typeIndex + 1);
        }
        if (major.length() < 1 || subtype.length() < 1) {
            throw new IllegalArgumentException("Failure parsing MediaType string: " + type);
        }
        String params = null;
        if (paramIndex > -1) {
            params = type.substring(paramIndex + 1);
        }
        if (params != null && !params.equals("")) {
            HashMap<String, String> typeParams = new HashMap<String, String>();
            int start = 0;
            while (start < params.length()) {
                start = HeaderParameterParser.setParam(typeParams, params, start);
            }
            return new MediaType(major, subtype, typeParams);
        }
        return new MediaType(major, subtype);
    }

    public static boolean quoted(String str) {
        for (char c : str.toCharArray()) {
            for (char q : quotedChars) {
                if (c != q) continue;
                return true;
            }
        }
        return false;
    }

    public String toString(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("param was null");
        }
        MediaType type = (MediaType)o;
        StringBuffer buf = new StringBuffer();
        buf.append(type.getType().toLowerCase()).append("/").append(type.getSubtype().toLowerCase());
        if (type.getParameters() == null || type.getParameters().size() == 0) {
            return buf.toString();
        }
        for (String name : type.getParameters().keySet()) {
            buf.append(';').append(name).append('=');
            String val = (String)type.getParameters().get(name);
            if (MediaTypeHeaderDelegate.quoted(val)) {
                buf.append('\"').append(val).append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }
}

