/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.reflect.Method;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMRunnerUtil;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMScripts;
import org.jboss.byteman.contrib.bmunit.BMUnit;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitConfigState;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.TestNGException;

public abstract class BMNGAbstractRunner
implements IHookable {
    BMUnitConfig classConfigAnnotation;
    BMScript classSingleScriptAnnotation;
    BMScripts classMultiScriptAnnotation;
    BMRules classMultiRuleAnnotation;
    BMRule classSingleRuleAnnotation;
    static Class currentClazz = null;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        callBack.runTestMethod(testResult);
    }

    public void bmngBeforeClass(Class<?> testKlazz) throws Exception {
        this.classConfigAnnotation = testKlazz.getAnnotation(BMUnitConfig.class);
        this.classSingleScriptAnnotation = testKlazz.getAnnotation(BMScript.class);
        this.classMultiScriptAnnotation = testKlazz.getAnnotation(BMScripts.class);
        this.classSingleRuleAnnotation = testKlazz.getAnnotation(BMRule.class);
        this.classMultiRuleAnnotation = testKlazz.getAnnotation(BMRules.class);
        if (this.classMultiRuleAnnotation != null && this.classSingleRuleAnnotation != null) {
            throw new TestNGException("Use either BMRule or BMRules annotation but not both");
        }
        if (this.classMultiScriptAnnotation != null && this.classSingleScriptAnnotation != null) {
            throw new TestNGException("Use either BMScript or BMScripts annotation but not both");
        }
        BMUnitConfigState.pushConfigurationState(this.classConfigAnnotation, testKlazz);
        if (this.classSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(this.classSingleScriptAnnotation.value());
            BMScript[] directory = BMRunnerUtil.normaliseLoadDirectory(this.classSingleScriptAnnotation);
            BMUnit.loadScriptFile(testKlazz, name, (String)directory);
        } else if (this.classMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = this.classMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value());
                String directory = BMRunnerUtil.normaliseLoadDirectory(script);
                BMUnit.loadScriptFile(testKlazz, name, directory);
            }
        }
        if (this.classSingleRuleAnnotation != null) {
            String scriptText = BMRunnerUtil.constructScriptText(new BMRule[]{this.classSingleRuleAnnotation});
            BMUnit.loadScriptText(testKlazz, null, scriptText);
        } else if (this.classMultiRuleAnnotation != null) {
            BMRule[] rules = this.classMultiRuleAnnotation.rules();
            String scriptText = BMRunnerUtil.constructScriptText(rules);
            BMUnit.loadScriptText(testKlazz, null, scriptText);
        }
    }

    public void bmngAfterClass(Class<?> testKlazz) throws Exception {
        if (this.classSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(this.classSingleScriptAnnotation.value());
            BMUnit.unloadScriptFile(testKlazz, name);
        } else if (this.classMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = this.classMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value());
                BMUnit.unloadScriptFile(testKlazz, name);
            }
        }
        if (this.classSingleRuleAnnotation != null) {
            BMUnit.unloadScriptText(testKlazz, null);
        } else if (this.classMultiRuleAnnotation != null) {
            BMRule[] rules = this.classMultiRuleAnnotation.rules();
            BMUnit.unloadScriptText(testKlazz, null);
        }
        BMUnitConfigState.popConfigurationState(testKlazz);
    }

    public void bmngBeforeTest(Method method) throws Exception {
        BMUnitConfig methodConfigAnnotation = method.getAnnotation(BMUnitConfig.class);
        BMScript methodSingleScriptAnnotation = method.getAnnotation(BMScript.class);
        BMScripts methodMultiScriptAnnotation = method.getAnnotation(BMScripts.class);
        BMRule methodSingleRuleAnnotation = method.getAnnotation(BMRule.class);
        BMRules methodMultiRuleAnnotation = method.getAnnotation(BMRules.class);
        if (methodMultiRuleAnnotation != null && methodSingleRuleAnnotation != null) {
            throw new TestNGException("Use either BMRule or BMRules annotation but not both");
        }
        if (methodMultiScriptAnnotation != null && methodSingleScriptAnnotation != null) {
            throw new TestNGException("Use either BMScript or BMScripts annotation but not both");
        }
        Class<?> testKlazz = method.getDeclaringClass();
        BMUnitConfigState.pushConfigurationState(methodConfigAnnotation, method);
        if (methodSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(methodSingleScriptAnnotation.value(), method);
            String string = BMRunnerUtil.normaliseLoadDirectory(methodSingleScriptAnnotation);
            BMUnit.loadScriptFile(testKlazz, name, string);
        } else if (methodMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = methodMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value(), method);
                String directory = BMRunnerUtil.normaliseLoadDirectory(script);
                BMUnit.loadScriptFile(testKlazz, name, directory);
            }
        }
        if (methodSingleRuleAnnotation != null) {
            String scriptText = BMRunnerUtil.constructScriptText(new BMRule[]{methodSingleRuleAnnotation});
            String string = method.getName();
            BMUnit.loadScriptText(testKlazz, string, scriptText);
        } else if (methodMultiRuleAnnotation != null) {
            BMRule[] rules = methodMultiRuleAnnotation.rules();
            String string = BMRunnerUtil.constructScriptText(rules);
            String name = method.getName();
            BMUnit.loadScriptText(testKlazz, name, string);
        }
    }

    public void bmngAfterTest(Method method) throws Exception {
        BMUnitConfig methodConfigAnnotation = method.getAnnotation(BMUnitConfig.class);
        BMScript methodSingleScriptAnnotation = method.getAnnotation(BMScript.class);
        BMScripts methodMultiScriptAnnotation = method.getAnnotation(BMScripts.class);
        BMRule methodSingleRuleAnnotation = method.getAnnotation(BMRule.class);
        BMRules methodMultiRuleAnnotation = method.getAnnotation(BMRules.class);
        Class<?> testKlazz = method.getDeclaringClass();
        if (methodSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(methodSingleScriptAnnotation.value(), method);
            String string = BMRunnerUtil.normaliseLoadDirectory(methodSingleScriptAnnotation);
            BMUnit.unloadScriptFile(testKlazz, name);
        } else if (methodMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = methodMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value(), method);
                String directory = BMRunnerUtil.normaliseLoadDirectory(script);
                BMUnit.unloadScriptFile(testKlazz, name);
            }
        }
        if (methodSingleRuleAnnotation != null) {
            String scriptText = BMRunnerUtil.constructScriptText(new BMRule[]{methodSingleRuleAnnotation});
            String string = method.getName();
            BMUnit.unloadScriptText(testKlazz, string);
        } else if (methodMultiRuleAnnotation != null) {
            BMRule[] rules = methodMultiRuleAnnotation.rules();
            String string = BMRunnerUtil.constructScriptText(rules);
            String name = method.getName();
            BMUnit.unloadScriptText(testKlazz, name);
        }
        BMUnitConfigState.popConfigurationState(method);
    }

    public void switchClass(Class newClazz) {
        if (currentClazz != null) {
            try {
                this.bmngAfterClass(currentClazz);
            }
            catch (Exception e) {
                try {
                    BMUnitConfigState.resetConfigurationState(currentClazz);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new TestNGException((Throwable)e);
            }
        }
        currentClazz = newClazz;
        if (newClazz != null) {
            try {
                this.bmngBeforeClass(newClazz);
            }
            catch (Exception e) {
                try {
                    BMUnitConfigState.resetConfigurationState(newClazz);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new TestNGException((Throwable)e);
            }
        }
    }
}

