/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$FluentIterable;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Sets;

@NotThreadSafe
public final class $TypeHierarchyCollector {
    private final List<DeclaredType> extendedClasses = $Lists.newArrayList();
    private final Set<DeclaredType> implementedInterfaces = $Sets.newLinkedHashSet();

    public void collectFrom(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            this.collectHierarchyMirrors(this.toDeclaredType(typeMirror), this.extendedClasses, this.implementedInterfaces);
        }
    }

    private DeclaredType toDeclaredType(TypeMirror typeMirror) {
        $Preconditions.checkArgument(typeMirror.getKind() == TypeKind.DECLARED);
        return (DeclaredType)typeMirror;
    }

    public $ImmutableList<DeclaredType> extendedClasses() {
        return $ImmutableList.copyOf(this.extendedClasses);
    }

    public $ImmutableSet<DeclaredType> implementedInterfaces() {
        return $ImmutableSet.copyOf(this.implementedInterfaces);
    }

    public $ImmutableList<String> extendedClassNames() {
        return $FluentIterable.from(this.extendedClasses).transform(ToNameOfTypeElement.FUNCTION).toList();
    }

    public $ImmutableSet<String> implementedInterfaceNames() {
        return $FluentIterable.from(this.implementedInterfaces).transform(ToNameOfTypeElement.FUNCTION).toSet();
    }

    private void collectHierarchyMirrors(DeclaredType topClass, List<DeclaredType> extendedClasses, Set<DeclaredType> implementedInterfaces) {
        if (topClass.getKind() != TypeKind.DECLARED || topClass.toString().equals(Object.class.getName())) {
            return;
        }
        this.collectInterfacesMirrors(topClass, implementedInterfaces);
        TypeElement e = this.toTypeElement(topClass);
        TypeMirror superclassMirror = e.getSuperclass();
        if (superclassMirror.getKind() != TypeKind.NONE) {
            DeclaredType superclass = this.toDeclaredType(superclassMirror);
            extendedClasses.add(superclass);
            this.collectHierarchyMirrors(superclass, extendedClasses, implementedInterfaces);
        }
        for (TypeMirror typeMirror : e.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            this.collectInterfacesMirrors(this.toDeclaredType(typeMirror), implementedInterfaces);
        }
    }

    private void collectInterfacesMirrors(DeclaredType topClass, Set<DeclaredType> implementedInterfaces) {
        TypeElement e = this.toTypeElement(topClass);
        if (e.getKind().isInterface()) {
            implementedInterfaces.add(topClass);
            for (TypeMirror typeMirror : e.getInterfaces()) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                this.collectInterfacesMirrors(this.toDeclaredType(typeMirror), implementedInterfaces);
            }
        }
    }

    private TypeElement toTypeElement(DeclaredType input) {
        return ToDeclaredTypeElement.FUNCTION.apply(input);
    }

    private static enum ToNameOfTypeElement implements $Function<DeclaredType, String>
    {
        FUNCTION;


        @Override
        public String apply(DeclaredType input) {
            return ToDeclaredTypeElement.FUNCTION.apply(input).getQualifiedName().toString();
        }
    }

    private static enum ToDeclaredTypeElement implements $Function<DeclaredType, TypeElement>
    {
        FUNCTION;


        @Override
        public TypeElement apply(DeclaredType input) {
            return (TypeElement)input.asElement();
        }
    }
}

