/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import java.util.Map;
import java.util.function.Supplier;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockScope;
import org.hibernate.LockOptions;

public final class LockOptionsHelper {
    private LockOptionsHelper() {
    }

    public static void applyPropertiesToLockOptions(Map<String, Object> props, Supplier<LockOptions> lockOptionsSupplier) {
        Object lockScope = props.get("javax.persistence.lock.scope");
        if (lockScope instanceof String && PessimisticLockScope.valueOf((String)((String)lockScope)) == PessimisticLockScope.EXTENDED) {
            lockOptionsSupplier.get().setScope(true);
        } else if (lockScope instanceof PessimisticLockScope) {
            boolean extended = PessimisticLockScope.EXTENDED.equals(lockScope);
            lockOptionsSupplier.get().setScope(extended);
        } else if (lockScope != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.scope: " + lockScope);
        }
        Object lockTimeout = props.get("javax.persistence.lock.timeout");
        int timeout = 0;
        boolean timeoutSet = false;
        if (lockTimeout instanceof String) {
            timeout = Integer.parseInt((String)lockTimeout);
            timeoutSet = true;
        } else if (lockTimeout instanceof Number) {
            timeout = ((Number)lockTimeout).intValue();
            timeoutSet = true;
        } else if (lockTimeout != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.timeout: " + lockTimeout);
        }
        if (timeoutSet) {
            if (timeout == -2) {
                lockOptionsSupplier.get().setTimeOut(-2);
            } else if (timeout < 0) {
                lockOptionsSupplier.get().setTimeOut(-1);
            } else if (timeout == 0) {
                lockOptionsSupplier.get().setTimeOut(0);
            } else {
                lockOptionsSupplier.get().setTimeOut(timeout);
            }
        }
    }
}

