/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring.scope;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.spring.scope.JaxrsRequestAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Provider
@PreMatching
public class RequestContextFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String REQUEST_ATTRIBUTES_PROPERTY = RequestContextFilter.class.getName() + ".REQUEST_ATTRIBUTES";
    private final SpringAttributeController attributeController;
    private static final SpringAttributeController EMPTY_ATTRIBUTE_CONTROLLER = new SpringAttributeController(){

        @Override
        public void setAttributes(ContainerRequestContext requestContext) {
        }

        @Override
        public void resetAttributes(ContainerRequestContext requestContext) {
        }
    };

    @Inject
    public RequestContextFilter(ServiceLocator locator) {
        ApplicationContext ctx = (ApplicationContext)locator.getService(ApplicationContext.class, new Annotation[0]);
        this.attributeController = ctx != null ? new SpringAttributeController(){

            @Override
            public void setAttributes(ContainerRequestContext requestContext) {
                JaxrsRequestAttributes attributes = new JaxrsRequestAttributes(requestContext);
                requestContext.setProperty(REQUEST_ATTRIBUTES_PROPERTY, (Object)attributes);
                RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            }

            @Override
            public void resetAttributes(ContainerRequestContext requestContext) {
                JaxrsRequestAttributes attributes = (JaxrsRequestAttributes)((Object)requestContext.getProperty(REQUEST_ATTRIBUTES_PROPERTY));
                RequestContextHolder.resetRequestAttributes();
                attributes.requestCompleted();
            }
        } : EMPTY_ATTRIBUTE_CONTROLLER;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.attributeController.setAttributes(requestContext);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.attributeController.resetAttributes(requestContext);
    }

    private static interface SpringAttributeController {
        public void setAttributes(ContainerRequestContext var1);

        public void resetAttributes(ContainerRequestContext var1);
    }
}

