/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import java.util.List;
import org.flowable.common.engine.impl.service.CommonServiceImpl;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskBuilder;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.TaskQueryImpl;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;

public class TaskServiceImpl
extends CommonServiceImpl<TaskServiceConfiguration>
implements TaskService {
    public TaskServiceImpl(TaskServiceConfiguration taskServiceConfiguration) {
        super((Object)taskServiceConfiguration);
    }

    @Override
    public TaskEntity getTask(String id) {
        return (TaskEntity)this.getTaskEntityManager().findById(id);
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.getTaskEntityManager().findTasksByExecutionId(executionId);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.getTaskEntityManager().findTasksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getTaskEntityManager().findTasksByParentTaskId(parentTaskId);
    }

    @Override
    public List<TaskEntity> findTasksBySubScopeIdScopeType(String subScopeId, String scopeType) {
        return this.getTaskEntityManager().findTasksBySubScopeIdAndScopeType(subScopeId, scopeType);
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl();
    }

    @Override
    public void changeTaskAssignee(TaskEntity taskEntity, String userId) {
        this.getTaskEntityManager().changeTaskAssignee(taskEntity, userId);
    }

    @Override
    public void changeTaskOwner(TaskEntity taskEntity, String ownerId) {
        this.getTaskEntityManager().changeTaskOwner(taskEntity, ownerId);
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String tenantId) {
        this.getTaskEntityManager().updateTaskTenantIdForDeployment(deploymentId, tenantId);
    }

    @Override
    public void updateTask(TaskEntity taskEntity, boolean fireUpdateEvent) {
        this.getTaskEntityManager().update(taskEntity, fireUpdateEvent);
    }

    @Override
    public void updateAllTaskRelatedEntityCountFlags(boolean configProperty) {
        this.getTaskEntityManager().updateAllTaskRelatedEntityCountFlags(configProperty);
    }

    @Override
    public TaskEntity createTask() {
        return (TaskEntity)this.getTaskEntityManager().create();
    }

    @Override
    public void insertTask(TaskEntity taskEntity, boolean fireCreateEvent) {
        this.getTaskEntityManager().insert(taskEntity, fireCreateEvent);
    }

    @Override
    public void deleteTask(TaskEntity task, boolean fireEvents) {
        this.getTaskEntityManager().delete(task, fireEvents);
    }

    @Override
    public void deleteTasksByExecutionId(String executionId) {
        this.getTaskEntityManager().deleteTasksByExecutionId(executionId);
    }

    public TaskEntityManager getTaskEntityManager() {
        return ((TaskServiceConfiguration)((Object)this.configuration)).getTaskEntityManager();
    }

    @Override
    public Task createTask(TaskBuilder taskBuilder) {
        return this.getTaskEntityManager().createTask(taskBuilder);
    }
}

