/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor.multitenant;

import java.util.List;
import org.flowable.common.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.flowable.job.service.impl.asyncexecutor.AcquireJobsRunnableConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.flowable.job.service.impl.asyncexecutor.AcquireTimerLifecycleListener;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.multitenant.ExecutorPerTenantAsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class TenantAwareAcquireTimerJobsRunnable
extends AcquireTimerJobsRunnable {
    protected TenantInfoHolder tenantInfoHolder;
    protected String tenantId;

    public TenantAwareAcquireTimerJobsRunnable(AsyncExecutor asyncExecutor, TenantInfoHolder tenantInfoHolder, String tenantId, int moveExecutorPoolSize) {
        this(asyncExecutor, tenantInfoHolder, tenantId, null, AcquireJobsRunnableConfiguration.DEFAULT, moveExecutorPoolSize);
    }

    public TenantAwareAcquireTimerJobsRunnable(AsyncExecutor asyncExecutor, TenantInfoHolder tenantInfoHolder, String tenantId, AcquireTimerLifecycleListener lifecycleListener, AcquireJobsRunnableConfiguration configuration, int moveExecutorPoolSize) {
        super(asyncExecutor, asyncExecutor.getJobServiceConfiguration().getJobManager(), lifecycleListener, configuration, moveExecutorPoolSize);
        this.tenantInfoHolder = tenantInfoHolder;
        this.tenantId = tenantId;
    }

    protected ExecutorPerTenantAsyncExecutor getTenantAwareAsyncExecutor() {
        return (ExecutorPerTenantAsyncExecutor)this.asyncExecutor;
    }

    @Override
    public synchronized void run() {
        this.tenantInfoHolder.setCurrentTenantId(this.tenantId);
        super.run();
        this.tenantInfoHolder.clearCurrentTenantId();
    }

    @Override
    protected void executeMoveTimerJobsToExecutableJobs(List<TimerJobEntity> timerJobs) {
        try {
            this.tenantInfoHolder.setCurrentTenantId(this.tenantId);
            super.executeMoveTimerJobsToExecutableJobs(timerJobs);
        }
        finally {
            this.tenantInfoHolder.clearCurrentTenantId();
        }
    }
}

