/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockExclusiveJobCmd.class);
    protected Job job;

    public UnlockExclusiveJobCmd(Job job) {
        this.job = job;
    }

    public Object execute(CommandContext commandContext) {
        InternalJobManager jobScopeInterface;
        if (this.job == null) {
            throw new FlowableIllegalArgumentException("job is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unlocking exclusive job {}", (Object)this.job.getId());
        }
        if (this.job.isExclusive() && this.job.getProcessInstanceId() != null && (jobScopeInterface = CommandContextUtil.getJobServiceConfiguration().getInternalJobManager()) != null) {
            jobScopeInterface.clearJobScopeLock(this.job);
        }
        return null;
    }
}

