/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.AbstractQuery;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.job.api.Job;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.service.impl.JobQueryProperty;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class SuspendedJobQueryImpl
extends AbstractQuery<SuspendedJobQuery, Job>
implements SuspendedJobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processInstanceId;
    protected String executionId;
    protected String handlerType;
    protected String processDefinitionId;
    protected boolean retriesLeft;
    protected boolean executable;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean noRetriesLeft;

    public SuspendedJobQueryImpl() {
    }

    public SuspendedJobQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public SuspendedJobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public SuspendedJobQueryImpl jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    public SuspendedJobQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public SuspendedJobQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public SuspendedJobQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public SuspendedJobQueryImpl handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    public SuspendedJobQueryImpl withRetriesLeft() {
        this.retriesLeft = true;
        return this;
    }

    public SuspendedJobQueryImpl executable() {
        this.executable = true;
        return this;
    }

    public SuspendedJobQueryImpl timers() {
        if (this.onlyMessages) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    public SuspendedJobQueryImpl messages() {
        if (this.onlyTimers) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    public SuspendedJobQueryImpl duedateHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThan = date;
        return this;
    }

    public SuspendedJobQueryImpl duedateLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThan = date;
        return this;
    }

    public SuspendedJobQueryImpl duedateHigherThen(Date date) {
        return this.duedateHigherThan(date);
    }

    public SuspendedJobQueryImpl duedateHigherThenOrEquals(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThanOrEqual = date;
        return this;
    }

    public SuspendedJobQueryImpl duedateLowerThen(Date date) {
        return this.duedateLowerThan(date);
    }

    public SuspendedJobQueryImpl duedateLowerThenOrEquals(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThanOrEqual = date;
        return this;
    }

    public SuspendedJobQueryImpl noRetriesLeft() {
        this.noRetriesLeft = true;
        return this;
    }

    public SuspendedJobQueryImpl withException() {
        this.withException = true;
        return this;
    }

    public SuspendedJobQueryImpl exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    public SuspendedJobQueryImpl jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public SuspendedJobQueryImpl jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public SuspendedJobQueryImpl jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public SuspendedJobQuery orderByJobDuedate() {
        return (SuspendedJobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    public SuspendedJobQuery orderByExecutionId() {
        return (SuspendedJobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    public SuspendedJobQuery orderByJobId() {
        return (SuspendedJobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    public SuspendedJobQuery orderByProcessInstanceId() {
        return (SuspendedJobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    public SuspendedJobQuery orderByJobRetries() {
        return (SuspendedJobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    public SuspendedJobQuery orderByTenantId() {
        return (SuspendedJobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getSuspendedJobEntityManager(commandContext).findJobCountByQueryCriteria(this);
    }

    public List<Job> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getSuspendedJobEntityManager(commandContext).findJobsByQueryCriteria(this);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public Date getNow() {
        return CommandContextUtil.getJobServiceConfiguration().getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isOnlyTimers() {
        return this.onlyTimers;
    }

    public boolean isOnlyMessages() {
        return this.onlyMessages;
    }

    public Date getDuedateHigherThan() {
        return this.duedateHigherThan;
    }

    public Date getDuedateLowerThan() {
        return this.duedateLowerThan;
    }

    public Date getDuedateHigherThanOrEqual() {
        return this.duedateHigherThanOrEqual;
    }

    public Date getDuedateLowerThanOrEqual() {
        return this.duedateLowerThanOrEqual;
    }

    public boolean isNoRetriesLeft() {
        return this.noRetriesLeft;
    }
}

