/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.management.TableMetaData;
import org.flowable.engine.common.api.management.TablePage;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.Token;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.TablePageQueryImpl;
import org.flowable.idm.engine.impl.persistence.AbstractManager;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntity;
import org.flowable.idm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.flowable.idm.engine.impl.persistence.entity.IdmByteArrayEntity;
import org.flowable.idm.engine.impl.persistence.entity.IdmPropertyEntity;
import org.flowable.idm.engine.impl.persistence.entity.MembershipEntity;
import org.flowable.idm.engine.impl.persistence.entity.PrivilegeEntity;
import org.flowable.idm.engine.impl.persistence.entity.TableDataManager;
import org.flowable.idm.engine.impl.persistence.entity.TokenEntity;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataManagerImpl
extends AbstractManager
implements TableDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDataManagerImpl.class);
    public static Map<Class<?>, String> apiTypeToTableNameMap = new HashMap();
    public static Map<Class<? extends Entity>, String> entityToTableNameMap = new HashMap<Class<? extends Entity>, String>();

    public TableDataManagerImpl(IdmEngineConfiguration idmEngineConfiguration) {
        super(idmEngineConfiguration);
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    @Override
    public Map<String, Long> getTableCount() {
        HashMap<String, Long> tableCount = new HashMap<String, Long>();
        try {
            for (String tableName : this.getTablesPresentInDatabase()) {
                tableCount.put(tableName, this.getTableCount(tableName));
            }
            LOGGER.debug("Number of rows per flowable table: {}", tableCount);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't get table counts", (Throwable)e);
        }
        return tableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTablesPresentInDatabase() {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = this.getDbSqlSession().getSqlSession().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet tables = null;){
                LOGGER.debug("retrieving flowable tables from jdbc metadata");
                String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
                String tableNameFilter = databaseTablePrefix + "ACT_%";
                if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = databaseTablePrefix + "act_%";
                }
                if ("oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = databaseTablePrefix + "ACT" + databaseMetaData.getSearchStringEscape() + "_%";
                }
                String catalog = null;
                if (this.getIdmEngineConfiguration().getDatabaseCatalog() != null && this.getIdmEngineConfiguration().getDatabaseCatalog().length() > 0) {
                    catalog = this.getIdmEngineConfiguration().getDatabaseCatalog();
                }
                String schema = null;
                if (this.getIdmEngineConfiguration().getDatabaseSchema() != null && this.getIdmEngineConfiguration().getDatabaseSchema().length() > 0) {
                    schema = "oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) ? this.getIdmEngineConfiguration().getDatabaseSchema().toUpperCase() : this.getIdmEngineConfiguration().getDatabaseSchema();
                }
                tables = databaseMetaData.getTables(catalog, schema, tableNameFilter, DbSqlSession.JDBC_METADATA_TABLE_TYPES);
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    tableName = tableName.toUpperCase();
                    tableNames.add(tableName);
                    LOGGER.debug("  retrieved flowable table name {}", (Object)tableName);
                }
            }
        }
        catch (Exception e) {
            throw new FlowableException("couldn't get flowable table names using metadata: " + e.getMessage(), (Throwable)e);
        }
        return tableNames;
    }

    protected long getTableCount(String tableName) {
        LOGGER.debug("selecting table count for {}", (Object)tableName);
        Long count = (Long)this.getDbSqlSession().selectOne("org.flowable.idm.engine.impl.TablePageMap.selectTableCount", Collections.singletonMap("tableName", tableName));
        return count;
    }

    @Override
    public TablePage getTablePage(TablePageQueryImpl tablePageQuery, int firstResult, int maxResults) {
        TablePage tablePage = new TablePage();
        List tableData = this.getDbSqlSession().getSqlSession().selectList("selectTableData", (Object)tablePageQuery, new RowBounds(firstResult, maxResults));
        tablePage.setTableName(tablePageQuery.getTableName());
        tablePage.setTotal(this.getTableCount(tablePageQuery.getTableName()));
        tablePage.setRows(tableData);
        tablePage.setFirstResult((long)firstResult);
        return tablePage;
    }

    @Override
    public String getTableName(Class<?> entityClass, boolean withPrefix) {
        String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = null;
        tableName = Entity.class.isAssignableFrom(entityClass) ? entityToTableNameMap.get(entityClass) : apiTypeToTableNameMap.get(entityClass);
        if (withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        TableMetaData result = new TableMetaData();
        try {
            result.setTableName(tableName);
            DatabaseMetaData metaData = this.getDbSqlSession().getSqlSession().getConnection().getMetaData();
            if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                tableName = tableName.toLowerCase();
            }
            String catalog = null;
            if (this.getIdmEngineConfiguration().getDatabaseCatalog() != null && this.getIdmEngineConfiguration().getDatabaseCatalog().length() > 0) {
                catalog = this.getIdmEngineConfiguration().getDatabaseCatalog();
            }
            String schema = null;
            if (this.getIdmEngineConfiguration().getDatabaseSchema() != null && this.getIdmEngineConfiguration().getDatabaseSchema().length() > 0) {
                schema = "oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType()) ? this.getIdmEngineConfiguration().getDatabaseSchema().toUpperCase() : this.getIdmEngineConfiguration().getDatabaseSchema();
            }
            ResultSet resultSet = metaData.getColumns(catalog, schema, tableName, null);
            while (resultSet.next()) {
                boolean wrongSchema = false;
                if (schema != null && schema.length() > 0) {
                    for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                        String columnName = resultSet.getMetaData().getColumnName(i + 1);
                        if (!"TABLE_SCHEM".equalsIgnoreCase(columnName) && !"TABLE_SCHEMA".equalsIgnoreCase(columnName)) continue;
                        if (schema.equalsIgnoreCase(resultSet.getString(resultSet.getMetaData().getColumnName(i + 1)))) break;
                        wrongSchema = true;
                        break;
                    }
                }
                if (wrongSchema) continue;
                String name = resultSet.getString("COLUMN_NAME").toUpperCase();
                String type = resultSet.getString("TYPE_NAME").toUpperCase();
                result.addColumnMetaData(name, type);
            }
        }
        catch (SQLException e) {
            throw new FlowableException("Could not retrieve database metadata: " + e.getMessage());
        }
        if (result.getColumnNames().isEmpty()) {
            result = null;
        }
        return result;
    }

    static {
        entityToTableNameMap.put(GroupEntity.class, "ACT_ID_GROUP");
        entityToTableNameMap.put(MembershipEntity.class, "ACT_ID_MEMBERSHIP");
        entityToTableNameMap.put(UserEntity.class, "ACT_ID_USER");
        entityToTableNameMap.put(IdentityInfoEntity.class, "ACT_ID_INFO");
        entityToTableNameMap.put(TokenEntity.class, "ACT_ID_TOKEN");
        entityToTableNameMap.put(PrivilegeEntity.class, "ACT_ID_PRIV");
        entityToTableNameMap.put(IdmPropertyEntity.class, "ACT_ID_PROPERTY");
        entityToTableNameMap.put(IdmByteArrayEntity.class, "ACT_ID_BYTEARRAY");
        apiTypeToTableNameMap.put(Group.class, "ACT_ID_GROUP");
        apiTypeToTableNameMap.put(User.class, "ACT_ID_USER");
        apiTypeToTableNameMap.put(Token.class, "ACT_ID_TOKEN");
        apiTypeToTableNameMap.put(Privilege.class, "ACT_ID_PRIV");
    }
}

