/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.query.QueryProperty;
import org.flowable.engine.common.impl.AbstractQuery;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.api.UserQueryProperty;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class UserQueryImpl
extends AbstractQuery<UserQuery, User>
implements UserQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected List<String> ids;
    protected String idIgnoreCase;
    protected String firstName;
    protected String firstNameLike;
    protected String firstNameLikeIgnoreCase;
    protected String lastName;
    protected String lastNameLike;
    protected String lastNameLikeIgnoreCase;
    protected String fullNameLike;
    protected String fullNameLikeIgnoreCase;
    protected String email;
    protected String emailLike;
    protected String groupId;
    protected List<String> groupIds;

    public UserQueryImpl() {
    }

    public UserQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public UserQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public UserQuery userId(String id) {
        if (id == null) {
            throw new FlowableIllegalArgumentException("Provided id is null");
        }
        this.id = id;
        return this;
    }

    public UserQuery userIds(List<String> ids) {
        if (ids == null) {
            throw new FlowableIllegalArgumentException("Provided ids is null");
        }
        this.ids = ids;
        return this;
    }

    public UserQuery userIdIgnoreCase(String id) {
        if (id == null) {
            throw new FlowableIllegalArgumentException("Provided id is null");
        }
        this.idIgnoreCase = id.toLowerCase();
        return this;
    }

    public UserQuery userFirstName(String firstName) {
        if (firstName == null) {
            throw new FlowableIllegalArgumentException("Provided first name is null");
        }
        this.firstName = firstName;
        return this;
    }

    public UserQuery userFirstNameLike(String firstNameLike) {
        if (firstNameLike == null) {
            throw new FlowableIllegalArgumentException("Provided first name is null");
        }
        this.firstNameLike = firstNameLike;
        return this;
    }

    public UserQuery userFirstNameLikeIgnoreCase(String firstNameLikeIgnoreCase) {
        if (firstNameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Provided first name is null");
        }
        this.firstNameLikeIgnoreCase = firstNameLikeIgnoreCase.toLowerCase();
        return this;
    }

    public UserQuery userLastName(String lastName) {
        if (lastName == null) {
            throw new FlowableIllegalArgumentException("Provided last name is null");
        }
        this.lastName = lastName;
        return this;
    }

    public UserQuery userLastNameLike(String lastNameLike) {
        if (lastNameLike == null) {
            throw new FlowableIllegalArgumentException("Provided last name is null");
        }
        this.lastNameLike = lastNameLike;
        return this;
    }

    public UserQuery userLastNameLikeIgnoreCase(String lastNameLikeIgnoreCase) {
        if (lastNameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Provided last name is null");
        }
        this.lastNameLikeIgnoreCase = lastNameLikeIgnoreCase.toLowerCase();
        return this;
    }

    public UserQuery userFullNameLike(String fullNameLike) {
        if (fullNameLike == null) {
            throw new FlowableIllegalArgumentException("Provided full name is null");
        }
        this.fullNameLike = fullNameLike;
        return this;
    }

    public UserQuery userFullNameLikeIgnoreCase(String fullNameLikeIgnoreCase) {
        if (fullNameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Provided full name is null");
        }
        this.fullNameLikeIgnoreCase = fullNameLikeIgnoreCase.toLowerCase();
        return this;
    }

    public UserQuery userEmail(String email) {
        if (email == null) {
            throw new FlowableIllegalArgumentException("Provided email is null");
        }
        this.email = email;
        return this;
    }

    public UserQuery userEmailLike(String emailLike) {
        if (emailLike == null) {
            throw new FlowableIllegalArgumentException("Provided emailLike is null");
        }
        this.emailLike = emailLike;
        return this;
    }

    public UserQuery memberOfGroup(String groupId) {
        if (groupId == null) {
            throw new FlowableIllegalArgumentException("Provided groupId is null");
        }
        this.groupId = groupId;
        return this;
    }

    public UserQuery memberOfGroups(List<String> groupIds) {
        if (groupIds == null) {
            throw new FlowableIllegalArgumentException("Provided groupIds is null");
        }
        this.groupIds = groupIds;
        return this;
    }

    public UserQuery orderByUserId() {
        return (UserQuery)this.orderBy((QueryProperty)UserQueryProperty.USER_ID);
    }

    public UserQuery orderByUserEmail() {
        return (UserQuery)this.orderBy((QueryProperty)UserQueryProperty.EMAIL);
    }

    public UserQuery orderByUserFirstName() {
        return (UserQuery)this.orderBy((QueryProperty)UserQueryProperty.FIRST_NAME);
    }

    public UserQuery orderByUserLastName() {
        return (UserQuery)this.orderBy((QueryProperty)UserQueryProperty.LAST_NAME);
    }

    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getUserEntityManager(commandContext).findUserCountByQueryCriteria(this);
    }

    public List<User> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getUserEntityManager(commandContext).findUserByQueryCriteria(this);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public String getIdIgnoreCase() {
        return this.idIgnoreCase;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFirstNameLike() {
        return this.firstNameLike;
    }

    public String getFirstNameLikeIgnoreCase() {
        return this.firstNameLikeIgnoreCase;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLastNameLike() {
        return this.lastNameLike;
    }

    public String getLastNameLikeIgnoreCase() {
        return this.lastNameLikeIgnoreCase;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailLike() {
        return this.emailLike;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public String getFullNameLike() {
        return this.fullNameLike;
    }

    public String getFullNameLikeIgnoreCase() {
        return this.fullNameLikeIgnoreCase;
    }
}

