/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.job.api.Job;
import org.flowable.job.service.ScopeAwareInternalJobManager;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DefaultInternalJobManager
extends ScopeAwareInternalJobManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultInternalJobManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    protected VariableScope resolveVariableScopeInternal(Job job) {
        if (job.getExecutionId() != null) {
            return (VariableScope)this.getExecutionEntityManager().findById(job.getExecutionId());
        }
        return null;
    }

    protected boolean handleJobInsertInternal(Job job) {
        if (job.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(job.getExecutionId());
            if (execution != null) {
                if (execution.getTenantId() != null) {
                    ((AbstractRuntimeJobEntity)job).setTenantId(execution.getTenantId());
                }
                CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                if (job instanceof TimerJobEntity) {
                    TimerJobEntity timerJobEntity = (TimerJobEntity)job;
                    if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                        countingExecutionEntity.setTimerJobCount(countingExecutionEntity.getTimerJobCount() + 1);
                    }
                } else if (job instanceof JobEntity) {
                    JobEntity jobEntity = (JobEntity)job;
                    if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                        countingExecutionEntity.setJobCount(countingExecutionEntity.getJobCount() + 1);
                    }
                } else if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                    if (job instanceof SuspendedJobEntity) {
                        countingExecutionEntity.setSuspendedJobCount(countingExecutionEntity.getSuspendedJobCount() + 1);
                    } else if (job instanceof DeadLetterJobEntity) {
                        countingExecutionEntity.setDeadLetterJobCount(countingExecutionEntity.getDeadLetterJobCount() + 1);
                    } else if (job instanceof ExternalWorkerJobEntity) {
                        countingExecutionEntity.setExternalWorkerJobCount(countingExecutionEntity.getExternalWorkerJobCount() + 1);
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected void handleJobDeleteInternal(Job job) {
        ExecutionEntity executionEntity;
        if (job.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(executionEntity = (ExecutionEntity)this.getExecutionEntityManager().findById(job.getExecutionId()))) {
            CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)executionEntity);
            if (job instanceof JobEntity) {
                countingExecutionEntity.setJobCount(countingExecutionEntity.getJobCount() - 1);
            } else if (job instanceof TimerJobEntity) {
                countingExecutionEntity.setTimerJobCount(countingExecutionEntity.getTimerJobCount() - 1);
            } else if (job instanceof SuspendedJobEntity) {
                countingExecutionEntity.setSuspendedJobCount(countingExecutionEntity.getSuspendedJobCount() - 1);
            } else if (job instanceof DeadLetterJobEntity) {
                countingExecutionEntity.setDeadLetterJobCount(countingExecutionEntity.getDeadLetterJobCount() - 1);
            } else if (job instanceof ExternalWorkerJobEntity) {
                countingExecutionEntity.setExternalWorkerJobCount(countingExecutionEntity.getExternalWorkerJobCount() - 1);
            }
        }
    }

    protected void lockJobScopeInternal(Job job) {
        ExecutionEntityManager executionEntityManager = this.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(job.getExecutionId());
        if (execution != null) {
            String lockOwner = null;
            Date lockExpirationTime = null;
            if (job instanceof JobInfoEntity) {
                lockOwner = ((JobInfoEntity)job).getLockOwner();
                lockExpirationTime = ((JobInfoEntity)job).getLockExpirationTime();
            }
            if (lockOwner == null || lockExpirationTime == null) {
                int lockMillis = this.processEngineConfiguration.getAsyncExecutor().getAsyncJobLockTimeInMillis();
                GregorianCalendar lockCal = new GregorianCalendar();
                lockCal.setTime(this.processEngineConfiguration.getClock().getCurrentTime());
                lockCal.add(14, lockMillis);
                lockOwner = this.processEngineConfiguration.getAsyncExecutor().getLockOwner();
                lockExpirationTime = lockCal.getTime();
            }
            executionEntityManager.updateProcessInstanceLockTime(execution.getProcessInstanceId(), lockOwner, lockExpirationTime);
            if (this.processEngineConfiguration.isLoggingSessionEnabled()) {
                FlowElement flowElement = execution.getCurrentFlowElement();
                BpmnLoggingSessionUtil.addAsyncActivityLoggingData("Locking job for " + flowElement.getId() + ", with job id " + job.getId(), "serviceTaskLockJob", (JobEntity)job, flowElement, execution);
            }
        }
    }

    protected void clearJobScopeLockInternal(Job job) {
        ExecutionEntityManager executionEntityManager = this.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(job.getProcessInstanceId());
        if (execution != null) {
            executionEntityManager.clearProcessInstanceLockTime(execution.getId());
        }
        if (this.processEngineConfiguration.isLoggingSessionEnabled()) {
            ExecutionEntity localExecution = (ExecutionEntity)executionEntityManager.findById(job.getExecutionId());
            FlowElement flowElement = localExecution.getCurrentFlowElement();
            BpmnLoggingSessionUtil.addAsyncActivityLoggingData("Unlocking job for " + flowElement.getId() + ", with job id " + job.getId(), "serviceTaskUnlockJob", (JobEntity)job, flowElement, localExecution);
        }
    }

    protected void preTimerJobDeleteInternal(JobEntity jobEntity, VariableScope variableScope) {
        Process process;
        String activityId = jobEntity.getJobHandlerConfiguration();
        if (jobEntity.getJobHandlerType().equalsIgnoreCase("timer-start-event") || jobEntity.getJobHandlerType().equalsIgnoreCase("trigger-timer")) {
            activityId = TimerEventHandler.getActivityIdFromConfiguration(jobEntity.getJobHandlerConfiguration());
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(jobEntity.getJobHandlerConfiguration());
            if (endDateExpressionString != null) {
                Expression endDateExpression = this.processEngineConfiguration.getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                BusinessCalendar businessCalendar = this.processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.getCalendarNameFromConfiguration(jobEntity.getJobHandlerConfiguration()), variableScope));
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue((VariableContainer)variableScope);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        jobEntity.setEndDate((Date)endDateValue);
                    } else {
                        throw new FlowableException("Timer '" + ((ExecutionEntity)variableScope).getActivityId() + "' in " + variableScope + " was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (jobEntity.getEndDate() == null) {
                        jobEntity.setEndDate(businessCalendar.resolveEndDate(endDateString));
                    }
                }
            }
        }
        int maxIterations = 1;
        if (jobEntity.getProcessDefinitionId() != null && (maxIterations = this.getMaxIterations(process = ProcessDefinitionUtil.getProcess(jobEntity.getProcessDefinitionId()), activityId)) <= 1) {
            maxIterations = this.getMaxIterations(process, activityId);
        }
        jobEntity.setMaxIterations(maxIterations);
    }

    protected void preRepeatedTimerScheduleInternal(TimerJobEntity ti, VariableScope variableScope) {
    }

    protected int getMaxIterations(Process process, String activityId) {
        Event event;
        List eventDefinitions;
        FlowElement flowElement = process.getFlowElement(activityId, true);
        if (flowElement != null && flowElement instanceof Event && (eventDefinitions = (event = (Event)flowElement).getEventDefinitions()) != null) {
            for (EventDefinition eventDefinition : eventDefinitions) {
                TimerEventDefinition timerEventDefinition;
                if (!(eventDefinition instanceof TimerEventDefinition) || (timerEventDefinition = (TimerEventDefinition)eventDefinition).getTimeCycle() == null) continue;
                return this.calculateMaxIterationsValue(timerEventDefinition.getTimeCycle());
            }
        }
        return -1;
    }

    protected int calculateMaxIterationsValue(String originalExpression) {
        int times = Integer.MAX_VALUE;
        List<String> expression = Arrays.asList(originalExpression.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1) {
            times = Integer.parseInt(expression.get(0).substring(1));
        }
        return times;
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = "cycle";
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            businessCalendarName = (String)CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue((VariableContainer)variableScope);
        }
        return businessCalendarName;
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return this.processEngineConfiguration.getExecutionEntityManager();
    }
}

